/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.internal.util;

import java.io.File;

public class FileUtils
extends net.ssehub.easy.basics.io.FileUtils {
    public static final char SEPARATOR = '/';
    public static final String SEPARATOR_STRING = String.valueOf('/');

    private FileUtils() {
    }

    public static final File makeAbsoluteFile(File baseFolder, String location) {
        File result;
        if (location == null) {
            result = null;
        } else {
            result = new File(location);
            if (!result.isAbsolute()) {
                result = new File(baseFolder, location);
            }
        }
        return result;
    }

    public static final String makeAbsolute(File baseFolder, String location) {
        File tmp = FileUtils.makeAbsoluteFile(baseFolder, location);
        String result = tmp != null ? tmp.getAbsolutePath() : null;
        return result;
    }

    public static final String makeRelative(File baseFolder, File location) {
        String tmp;
        if (location != null) {
            String baseTmp;
            tmp = location.getAbsolutePath();
            if (baseFolder != null && tmp.startsWith(baseTmp = baseFolder.getAbsolutePath()) && tmp.length() > baseTmp.length()) {
                tmp = tmp.substring(baseTmp.length() + 1);
            }
        } else {
            tmp = null;
        }
        return tmp;
    }

    public static final File makeRelativeFile(File baseFolder, File location) {
        String tmp = FileUtils.makeRelative(baseFolder, location);
        File result = tmp == null ? null : new File(tmp);
        return result;
    }

    public static final String fromIndependent(String file) {
        String result = file != null ? file.replace('/', File.separatorChar) : null;
        return result;
    }

    public static final String fromIndependent(File file) {
        String result = file != null ? FileUtils.fromIndependent(file.getAbsolutePath()) : null;
        return result;
    }

    public static final File toIndependentFile(String file) {
        String tmp = FileUtils.toIndependent(file);
        File result = tmp != null ? new File(tmp) : null;
        return result;
    }

    public static final String toIndependent(String file) {
        String result = file != null ? file.replace(File.separatorChar, '/') : null;
        return result;
    }
}

