/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NatureHelper {
    public static final String FILE_NAME = ".project";
    private static DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();

    public static boolean hasNature(File project, String ... natures) throws IOException {
        ProjectHandler handler = new ProjectHandler(project);
        return NatureHelper.hasNature(handler, natures);
    }

    private static boolean hasNature(ProjectHandler handler, String ... natures) {
        boolean found = false;
        NodeList nat = handler.getNatures();
        int i = 0;
        while (!found && i < natures.length) {
            int n = 0;
            while (!found && n < nat.getLength()) {
                found = NatureHelper.containsNature(nat.item(n).getChildNodes(), natures[i]);
                ++n;
            }
            ++i;
        }
        return found;
    }

    private static boolean checkNature(Node node, String nature) {
        return node.getTextContent().trim().equals(nature);
    }

    private static boolean containsNature(NodeList nodes, String nature) {
        boolean contains = false;
        int i = 0;
        while (!contains && i < nodes.getLength()) {
            contains = NatureHelper.checkNature(nodes.item(i), nature);
            ++i;
        }
        return contains;
    }

    public static void addNature(File project, String nature) throws IOException {
        ProjectHandler handler = new ProjectHandler(project);
        if (!NatureHelper.hasNature(handler, nature)) {
            NodeList nat = handler.getNatures();
            Node node = nat.getLength() == 0 ? handler.addNatureSection() : nat.item(0);
            handler.addNature(node, nature);
            handler.writeBack();
        }
    }

    public static void removeNature(File project, String nature) throws IOException {
        ProjectHandler handler = new ProjectHandler(project);
        NodeList natures = handler.getNatures();
        int i = 0;
        while (i < natures.getLength()) {
            NatureHelper.removeElements(natures.item(i), nature);
            ++i;
        }
        handler.writeBack();
    }

    private static void removeElements(Node parent, String nature) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (NatureHelper.checkNature(child, nature)) {
                    parent.removeChild(child);
                } else {
                    NatureHelper.removeElements(child, nature);
                }
            }
            ++i;
        }
    }

    private static class ProjectHandler {
        private File file;
        private DocumentBuilder dBuilder;
        private Document doc;

        private ProjectHandler(File project) throws IOException {
            try {
                this.file = new File(project, NatureHelper.FILE_NAME);
                this.dBuilder = dbFactory.newDocumentBuilder();
                this.doc = this.dBuilder.parse(this.file);
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private NodeList getNatures() {
            return this.doc.getElementsByTagName("natures");
        }

        private void writeBack() throws IOException {
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\r\n");
                transformer.setOutputProperty("method", "html");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                DOMSource source = new DOMSource(this.doc);
                StreamResult result = new StreamResult(this.file);
                FileOutputStream out = new FileOutputStream(this.file);
                result.setOutputStream(out);
                result.setWriter(new PrintWriter(out));
                result.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private Node addNatureSection() {
            Element root = this.doc.getDocumentElement();
            Element elem = this.doc.createElement("natures");
            root.appendChild(elem);
            return elem;
        }

        private Node addNature(Node node, String nature) {
            Element elem = this.doc.createElement("nature");
            elem.appendChild(this.doc.createTextNode(nature));
            node.appendChild(elem);
            return elem;
        }
    }
}

