/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;

public class StandaloneProjectDescriptor
implements IProjectDescriptor {
    private IProjectDescriptor parent;
    private File base;
    private Script vilScript;

    public StandaloneProjectDescriptor(ModelInfo<Script> vilInfo, File base) throws ModelManagementException {
        this.parent = null;
        this.base = base;
        this.vilScript = (Script)BuildModel.INSTANCE.load(vilInfo);
    }

    public StandaloneProjectDescriptor(Script vilScript, File base) throws ModelManagementException {
        this.parent = null;
        this.base = base;
        this.vilScript = vilScript;
    }

    public StandaloneProjectDescriptor(IProjectDescriptor parent, File base) {
        this.parent = parent;
        this.base = base;
        if (!base.exists()) {
            base.mkdirs();
        }
        this.vilScript = parent.getMainVilScript();
    }

    public File getBase() {
        return this.base;
    }

    public int getPredecessorCount() {
        return this.parent != null ? 1 : 0;
    }

    public IProjectDescriptor getPredecessor(int index) {
        if (index < 0 || index >= this.getPredecessorCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.parent;
    }

    public Script getMainVilScript() {
        return this.vilScript;
    }

    public ProgressObserver createObserver() {
        return ProgressObserver.NO_OBSERVER;
    }

    public String getModelFolder(IProjectDescriptor.ModelKind kind) {
        return switch (kind) {
            case IProjectDescriptor.ModelKind.IVML -> "EASy";
            case IProjectDescriptor.ModelKind.VIL -> "EASy";
            case IProjectDescriptor.ModelKind.VTL -> "EASy";
            default -> null;
        };
    }
}

