/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.enums;

import au.com.jcloud.lxd.model.response.AbstractResponse;
import au.com.jcloud.lxd.model.response.CertificateResponse;
import au.com.jcloud.lxd.model.response.ContainerResponse;
import au.com.jcloud.lxd.model.response.FileResponse;
import au.com.jcloud.lxd.model.response.ImageAliasResponse;
import au.com.jcloud.lxd.model.response.ImageResponse;
import au.com.jcloud.lxd.model.response.NetworkResponse;
import au.com.jcloud.lxd.model.response.OperationResponse;
import au.com.jcloud.lxd.model.response.ProfileResponse;
import au.com.jcloud.lxd.model.response.ServerInfoResponse;
import au.com.jcloud.lxd.model.response.SnapshotResponse;
import au.com.jcloud.lxd.model.response.StateResponse;

public enum LxdCall {
    GET_SERVERINFO("/1.0", ServerInfoResponse.class),
    GET_CONTAINER("/1.0/containers", ContainerResponse.class),
    GET_IMAGE("/1.0/images", ImageResponse.class),
    GET_IMAGEALIAS("/1.0/images/aliases", ImageAliasResponse.class),
    GET_CERTIFICATE("/1.0/certificates", CertificateResponse.class),
    GET_NETWORK("/1.0/networks", NetworkResponse.class),
    GET_OPERATION("/1.0/operations", OperationResponse.class),
    GET_PROFILE("/1.0/profiles", ProfileResponse.class),
    GET_STATE("/1.0/containers/${ID}/state", StateResponse.class),
    GET_SNAPSHOTS("/1.0/containers/${ID}/snapshots", SnapshotResponse.class),
    GET_FILE("/1.0/containers/${ID}/files?path=${PATH}", FileResponse.class),
    PUT_CONTAINER_STATE("/1.0/containers/${ID}/state -X PUT -d '{\"action\": \"${ACTION}\", ${TIMEOUT} \"force\": ${FORCE}, \"stateful\": ${STATEFUL} }'", OperationResponse.class),
    POST_CONTAINER_CREATE_REMOTE("/1.0/containers -X POST -d '{\"name\": \"${ID}\", ${EPHEMERAL} ${ARCHITECTURE} ${CONFIG} ${PROFILES} \"source\": {\"type\": \"image\", \"protocol\": \"${PROTOCOL}\", \"server\": \"${SERVERURL}\", \"alias\": \"${ALIAS}\"}}'", OperationResponse.class),
    POST_CONTAINER_CREATE_LOCAL("/1.0/containers -X POST -d '{\"name\": \"${ID}\", ${EPHEMERAL} ${ARCHITECTURE} ${CONFIG} ${PROFILES} \"source\": {\"type\": \"image\", \"fingerprint\": \"${ALIAS}\"}}'", OperationResponse.class),
    POST_CONTAINER_COPY("/1.0/containers -X POST -d '{\"name\": \"${ID}\", ${EPHEMERAL} ${ARCHITECTURE} ${CONFIG} ${PROFILES} \"source\": {\"type\": \"copy\", \"container_only\": \"${CONTAINERONLY}\", \"source\": \"${CONTAINER}\"}}'", OperationResponse.class),
    POST_CONTAINER_DELETE("/1.0/containers/${ID} -X DELETE", OperationResponse.class),
    POST_CONTAINER_RENAME("/1.0/containers/${ID} -X POST -d '{ \"name\": \"${NEWNAME}\" }'", OperationResponse.class),
    POST_CONTAINER_EXEC("/1.0/containers/${ID}/exec -X POST -d '{ \"command\": [\"${CMD}\"], \"environment\": {${ENV}}, \"wait-for-websocket\": ${WAIT}, \"interactive\": false }'", OperationResponse.class),
    POST_CONTAINER_FILES("/1.0/containers/${ID}/files?path=${PATH} -X POST", OperationResponse.class),
    POST_SNAPSHOT_CREATE("/1.0/containers/${ID}/snapshots -X POST -d '{\"name\": \"${SNAPNAME}\"}'", SnapshotResponse.class),
    POST_SNAPSHOT_DELETE("/1.0/containers/${ID}/snapshots/${SNAPNAME} -X DELETE", SnapshotResponse.class),
    POST_SNAPSHOT_RENAME("/1.0/containers/${ID}/snapshots/${SNAPNAME} -X POST -d '{ \"name\": \"${NEWNAME}\" }'", SnapshotResponse.class),
    POST_IMAGE_DELETE("/1.0/images/${ID} -X DELETE", ImageResponse.class),
    POST_IMAGEALIAS_CREATE("/1.0/images/aliases -X POST -d '{ \"description\": \"${DESCRIPTION}\", \"target\": \"${FINGERPRINT}\", \"name\": \"${NEWNAME}\" }'", ImageAliasResponse.class),
    POST_IMAGEALIAS_DELETE("/1.0/images/aliases/${ID} -X DELETE", ImageAliasResponse.class),
    POST_IMAGEALIAS_RENAME("/1.0/images/aliases/${ID} -X POST -d '{ \"name\": \"${NEWNAME}\", \"description\": \"${DESCRIPTION}\" }'", ImageAliasResponse.class),
    POST_PROFILE_DELETE("/1.0/profiles/${ID} -X DELETE", ProfileResponse.class),
    POST_NETWORK_DELETE("/1.0/networks/${ID} -X DELETE", ProfileResponse.class);

    private String command;
    private Class<? extends AbstractResponse> classType;

    private LxdCall(String command, Class<? extends AbstractResponse> classType) {
        this.command = command;
        this.classType = classType;
    }

    public String getCommand() {
        return this.command;
    }

    public Class<? extends AbstractResponse> getClassType() {
        return this.classType;
    }
}

