/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.model.extra;

import java.util.HashMap;
import java.util.Map;

public class NetworkInterface {
    public static final String ADDRESS_FAMILY = "family";
    public static final String ADDRESS_ADDRESS = "address";
    public static final String ADDRESS_NETMASK = "netmask";
    public static final String ADDRESS_SCOPE = "scope";
    private Map<IPType, Address> addressMap = new HashMap<IPType, Address>();
    private Map<String, String>[] addresses;
    private Map<String, String> counters;
    private String macAddress;
    private int mtu;
    private String state;
    private String type;

    public String toString() {
        return "ip=" + this.getIp4Address() + " state=" + this.state + " type=" + this.type;
    }

    public String getIp4Address() {
        return this.getAddressDataMap().get((Object)IPType.IP4) != null ? this.getAddressDataMap().get((Object)IPType.IP4).getAddress() : "";
    }

    public Map<IPType, Address> getAddressDataMap() {
        if (!this.addressMap.isEmpty()) {
            return this.addressMap;
        }
        for (Map<String, String> addressData : this.addresses) {
            IPType ipType = IPType.IP4;
            for (String key : addressData.keySet()) {
                Address address;
                if (key.equals(ADDRESS_FAMILY)) {
                    Address address2;
                    String value = addressData.get(key);
                    if (value.equals("inet6")) {
                        ipType = IPType.IP6;
                    }
                    if ((address2 = this.addressMap.get((Object)ipType)) == null) {
                        address2 = new Address();
                        this.addressMap.put(ipType, address2);
                    }
                    address2.family = ipType;
                    continue;
                }
                if (key.equals(ADDRESS_ADDRESS)) {
                    address = this.addressMap.get((Object)ipType);
                    if (address == null) {
                        address = new Address();
                        this.addressMap.put(ipType, address);
                    }
                    address.address = addressData.get(key);
                    continue;
                }
                if (key.equals(ADDRESS_NETMASK)) {
                    address = this.addressMap.get((Object)ipType);
                    if (address == null) {
                        address = new Address();
                        this.addressMap.put(ipType, address);
                    }
                    address.netmask = Integer.parseInt(addressData.get(key));
                    continue;
                }
                if (!key.equals(ADDRESS_SCOPE)) continue;
                address = this.addressMap.get((Object)ipType);
                if (address == null) {
                    address = new Address();
                    this.addressMap.put(ipType, address);
                }
                address.scope = addressData.get(key);
            }
        }
        return this.addressMap;
    }

    public Map<String, String>[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Map<String, String>[] addresses) {
        this.addresses = addresses;
    }

    public Map<String, String> getCounters() {
        return this.counters;
    }

    public void setCounters(Map<String, String> counters) {
        this.counters = counters;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public int getMtu() {
        return this.mtu;
    }

    public void setMtu(int mtu) {
        this.mtu = mtu;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    class Address {
        private IPType family;
        private String address;
        private int netmask;
        private String scope;

        Address() {
        }

        public IPType getFamily() {
            return this.family;
        }

        public void setFamily(IPType family) {
            this.family = family;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public int getNetmask() {
            return this.netmask;
        }

        public void setNetmask(int netmask) {
            this.netmask = netmask;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }
    }

    static enum IPType {
        IP4,
        IP6;

    }
}

