/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.service.impl;

import au.com.jcloud.lxd.bean.ImageConfig;
import au.com.jcloud.lxd.model.Certificate;
import au.com.jcloud.lxd.model.Container;
import au.com.jcloud.lxd.model.Image;
import au.com.jcloud.lxd.model.ImageAlias;
import au.com.jcloud.lxd.model.Network;
import au.com.jcloud.lxd.model.Operation;
import au.com.jcloud.lxd.model.Profile;
import au.com.jcloud.lxd.model.Snapshot;
import au.com.jcloud.lxd.model.State;
import au.com.jcloud.lxd.service.ICachingLxdService;
import au.com.jcloud.lxd.service.impl.LxdServiceImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class CachingLxdServiceImpl
extends LxdServiceImpl
implements ICachingLxdService {
    private static final Logger LOG = Logger.getLogger(CachingLxdServiceImpl.class);
    private Map<String, Container> containerMap;
    private Map<String, Image> imageMap;
    private Map<String, Operation> operationMap;
    private Map<String, Network> networkMap;
    private Map<String, Profile> profileMap;
    private Map<String, Certificate> certificateMap;
    private Map<String, ImageAlias> imageAliasMap;
    private Map<String, Map<String, Snapshot>> snapshotCache;

    @Override
    public ICachingLxdService clone() throws CloneNotSupportedException {
        CachingLxdServiceImpl newService = new CachingLxdServiceImpl();
        newService.setLxdApiService(this.lxdApiService);
        return newService;
    }

    @Override
    public Map<String, Container> getContainerMap() {
        if (this.containerMap != null && !this.containerMap.isEmpty()) {
            return this.containerMap;
        }
        this.reloadContainerCache();
        return this.containerMap;
    }

    @Override
    public Container getContainer(String name) {
        Container container = this.getContainerMap().get(name);
        return container;
    }

    @Override
    public State getContainerState(String name) {
        State state = this.getContainer(name).getState();
        return state;
    }

    @Override
    public void reloadContainerCache() {
        try {
            this.containerMap = super.loadContainerMap();
            for (Container container : this.containerMap.values()) {
                container.setState(super.loadContainerState(container.getName()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.containerMap = new HashMap<String, Container>();
        }
    }

    @Override
    public Map<String, Image> getImageMap() {
        if (this.imageMap != null && !this.imageMap.isEmpty()) {
            return this.imageMap;
        }
        this.reloadImageCache();
        return this.imageMap;
    }

    @Override
    public Image getImage(String name) {
        Image image = this.getImageMap().get(name);
        return image;
    }

    @Override
    public void reloadImageCache() {
        try {
            this.imageMap = super.loadImageMap();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.imageMap = new HashMap<String, Image>();
        }
    }

    @Override
    public void startContainer(String name) throws IOException, InterruptedException {
        super.startContainer(name);
        this.reloadContainerCache();
    }

    @Override
    public void stopContainer(String name) throws IOException, InterruptedException {
        super.stopContainer(name);
        this.reloadContainerCache();
    }

    @Override
    public void createContainer(String newContainerName, String imageAlias, ImageConfig imageConfig) throws IOException, InterruptedException {
        super.createContainer(newContainerName, imageAlias, imageConfig);
        this.reloadContainerCache();
    }

    @Override
    public void deleteContainer(String name) throws IOException, InterruptedException {
        super.deleteContainer(name);
        this.reloadContainerCache();
    }

    @Override
    public void renameContainer(String name, String newContainerName) throws IOException, InterruptedException {
        super.renameContainer(name, newContainerName);
        this.reloadContainerCache();
    }

    @Override
    public void copyContainer(String name, String newContainerName, Boolean containerOnly) throws IOException, InterruptedException {
        super.copyContainer(name, newContainerName, containerOnly);
        this.reloadContainerCache();
    }

    @Override
    public Map<String, Operation> getOperationMap() {
        if (this.operationMap != null && !this.operationMap.isEmpty()) {
            return this.operationMap;
        }
        this.reloadOperationCache();
        return this.operationMap;
    }

    @Override
    public Operation getOperation(String name) {
        Operation operation = this.getOperationMap().get(name);
        return operation;
    }

    @Override
    public void reloadOperationCache() {
        try {
            this.operationMap = super.loadOperationMap();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.operationMap = new HashMap<String, Operation>();
        }
    }

    @Override
    public Map<String, Network> getNetworkMap() {
        if (this.networkMap != null && !this.networkMap.isEmpty()) {
            return this.networkMap;
        }
        this.reloadNetworkCache();
        return this.networkMap;
    }

    @Override
    public Network getNetwork(String name) {
        Network network = this.getNetworkMap().get(name);
        return network;
    }

    @Override
    public void reloadNetworkCache() {
        try {
            this.networkMap = super.loadNetworkMap();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.networkMap = new HashMap<String, Network>();
        }
    }

    @Override
    public Map<String, Profile> getProfileMap() {
        if (this.profileMap != null && !this.profileMap.isEmpty()) {
            return this.profileMap;
        }
        this.reloadProfileCache();
        return this.profileMap;
    }

    @Override
    public Profile getProfile(String name) {
        Profile profile = this.getProfileMap().get(name);
        return profile;
    }

    @Override
    public void reloadProfileCache() {
        try {
            this.profileMap = super.loadProfileMap();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.profileMap = new HashMap<String, Profile>();
        }
    }

    @Override
    public void deleteProfile(String name) throws IOException, InterruptedException {
        super.deleteProfile(name);
        this.reloadProfileCache();
    }

    @Override
    public Map<String, Certificate> getCertificateMap() {
        if (this.certificateMap != null && !this.certificateMap.isEmpty()) {
            return this.certificateMap;
        }
        this.reloadCertificateCache();
        return this.certificateMap;
    }

    @Override
    public Certificate getCertificate(String name) {
        Certificate certificate = this.getCertificateMap().get(name);
        return certificate;
    }

    @Override
    public void reloadCertificateCache() {
        try {
            this.certificateMap = super.loadCertificateMap();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.certificateMap = new HashMap<String, Certificate>();
        }
    }

    @Override
    public Map<String, Snapshot> getSnapshotMap(Container container) {
        Map<String, Snapshot> snapshotMap;
        if (this.snapshotCache != null && !this.snapshotCache.isEmpty()) {
            this.snapshotCache = new HashMap<String, Map<String, Snapshot>>();
        }
        if ((snapshotMap = this.snapshotCache.get(container.getName())) != null && !snapshotMap.isEmpty()) {
            return snapshotMap;
        }
        try {
            snapshotMap = super.loadSnapshotMap(container);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            snapshotMap = new HashMap<String, Snapshot>();
        }
        this.snapshotCache.put(container.getName(), snapshotMap);
        return snapshotMap;
    }

    @Override
    public Snapshot getSnapshot(String containerName, String snapshotName) {
        Container container = new Container();
        container.setName(containerName);
        Snapshot snapshot = this.getSnapshotMap(container).get(snapshotName);
        return snapshot;
    }

    @Override
    public Map<String, ImageAlias> getImageAliasMap() {
        if (this.imageAliasMap != null && !this.imageAliasMap.isEmpty()) {
            return this.imageAliasMap;
        }
        this.reloadImageAliasCache();
        return this.imageAliasMap;
    }

    @Override
    public ImageAlias getImageAlias(String name) {
        ImageAlias imageAlias = this.getImageAliasMap().get(name);
        return imageAlias;
    }

    @Override
    public void createImageAlias(String aliasName, String targetFingerprint) throws IOException, InterruptedException {
        super.createImageAlias(aliasName, targetFingerprint);
        this.reloadImageAliasCache();
        this.reloadImageCache();
    }

    @Override
    public void deleteImageAlias(String aliasName) throws IOException, InterruptedException {
        super.deleteImageAlias(aliasName);
        this.reloadImageAliasCache();
        this.reloadImageCache();
    }

    @Override
    public void renameImageAlias(String aliasName, String newAliasName) throws IOException, InterruptedException {
        super.renameImageAlias(aliasName, newAliasName);
        this.reloadImageAliasCache();
        this.reloadImageCache();
    }

    @Override
    public void reloadImageAliasCache() {
        try {
            this.imageAliasMap = super.loadImageAliasMap();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            this.imageAliasMap = new HashMap<String, ImageAlias>();
        }
    }
}

