/*
 * Decompiled with CFR 0.152.
 */
package au.com.jcloud.lxd.service.impl;

import au.com.jcloud.lxd.LxdConstants;
import au.com.jcloud.lxd.service.ILinuxCliService;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.apache.log4j.Logger;

@Named
public class LinuxCliServiceImpl
implements ILinuxCliService {
    private static final Logger LOG = Logger.getLogger(LinuxCliServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeLinuxCmd(String cmd) throws IOException, InterruptedException {
        StringBuffer result = new StringBuffer();
        BufferedReader in = null;
        LOG.debug((Object)("cmd=" + cmd));
        System.out.println(cmd);
        try {
            String line;
            Process process = null;
            if (LxdConstants.IS_WINDOWS) {
                LOG.warn((Object)("Trying to execute linux command in Windows environment: " + cmd));
                process = Runtime.getRuntime().exec(cmd);
                process.getOutputStream().close();
            } else {
                String[] cmdArray = new String[]{"/bin/sh", "-c", cmd};
                process = Runtime.getRuntime().exec(cmdArray);
                process.getOutputStream().close();
            }
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            process.waitFor();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        LOG.debug((Object)("result=" + result));
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> executeLinuxCmdWithResultLines(String cmd) throws IOException, InterruptedException {
        Object[] cmdArray = new String[]{"/bin/sh", "-c", cmd};
        LOG.debug((Object)("cmd=" + cmdArray[2]));
        ArrayList<String> result = new ArrayList<String>();
        LOG.debug((Object)("cmd=" + cmdArray[2]));
        try (BufferedReader in = null;){
            String line;
            System.out.println(Arrays.toString(cmdArray));
            Process process = Runtime.getRuntime().exec((String[])cmdArray);
            process.getOutputStream().close();
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
            process.waitFor();
        }
        return result;
    }

    @Override
    public int executeLinuxCmdWithResultInt(String cmd) throws IOException, InterruptedException {
        String output = this.executeLinuxCmd(cmd);
        if (output.trim().length() > 0) {
            return Integer.parseInt(output.trim());
        }
        return 0;
    }

    @Override
    public <T> T executeLinuxCmdWithResultJsonObject(String cmd, Class<T> classType) throws IOException, InterruptedException {
        String output = this.executeLinuxCmd(cmd);
        if (output.trim().length() > 0) {
            LOG.debug((Object)("output=" + output));
            Gson gson = new Gson();
            return (T)gson.fromJson(output, classType);
        }
        return null;
    }

    @Override
    public int getLinesCountForFile(File readFile) throws IOException, InterruptedException {
        String cmd = "wc -l " + readFile.getAbsolutePath() + " | cut -f 1 -d ' '";
        return this.executeLinuxCmdWithResultInt(cmd);
    }

    @Override
    public List<String> getLastNFileLines(File readFile, int linesToRead) {
        return this.getLastNFileLines(readFile, linesToRead, 0);
    }

    @Override
    public List<String> getLastNFileLines(File readFile, int linesToRead, int headSize) {
        List<String> result = new ArrayList<String>();
        try {
            String cmd = "tail -" + linesToRead + " " + readFile.getAbsolutePath();
            if (headSize > 0) {
                cmd = cmd + " | head -" + headSize;
            }
            result = this.executeLinuxCmdWithResultLines(cmd);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return result;
    }

    @Override
    public String getFileNameWithoutExtension(String filename) {
        int index = filename.lastIndexOf(".");
        if (index > 0) {
            String filenameWithoutExtension = filename.substring(0, index);
            return filenameWithoutExtension;
        }
        return filename;
    }

    @Override
    public String getFileExtension(String filename) {
        int index = filename.lastIndexOf(".");
        return filename.substring(index + 1);
    }

    @Override
    public String firstCharUpperCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }
}

