/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.frontend;

import java.net.URI;
import java.util.List;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.DelegatingReasonerInstance;
import net.ssehub.easy.reasoning.core.reasoner.EvaluationResult;
import net.ssehub.easy.reasoning.core.reasoner.GeneralReasonerCapabilities;
import net.ssehub.easy.reasoning.core.reasoner.IChainingReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerMessage;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.capabilities.IReasonerCapability;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.Project;

public abstract class AbstractChainedReasoner
implements IChainingReasoner {
    private ReasonerDescriptor descriptor;
    private IChainingReasoner[] reasoners;
    private Configuration config;
    private ReasoningResult reasoningResult;
    private EvaluationResult evaluationResult;

    protected AbstractChainedReasoner(String name, String version, ReasonerDescriptor ... chain) throws IllegalArgumentException {
        this(AbstractChainedReasoner.deriveDescriptor(name, version, chain), chain);
    }

    protected AbstractChainedReasoner(ReasonerDescriptor descriptor, ReasonerDescriptor ... chain) {
        this.descriptor = descriptor;
        if (chain.length > 0 && !chain[0].hasCapability(GeneralReasonerCapabilities.STANDALONE_REASONING)) {
            throw new IllegalArgumentException("First reasoner in chain is not standalone");
        }
        this.reasoners = new IChainingReasoner[chain.length];
        int r = 0;
        while (r < this.reasoners.length) {
            IReasoner tmp = ReasonerFrontend.getInstance().findReasoner(chain[r]);
            if (tmp == null) {
                throw new IllegalArgumentException("Reasoner " + r + " in chain is not registered/null");
            }
            if (!(tmp instanceof IChainingReasoner)) {
                throw new IllegalArgumentException("Reasoner " + r + " in chain is not a chaining reasoner");
            }
            this.reasoners[r] = (IChainingReasoner)tmp;
            ++r;
        }
    }

    private static ReasonerDescriptor deriveDescriptor(String name, String version, ReasonerDescriptor[] chain) {
        String license = "";
        String licenseRestriction = "";
        int c = 0;
        while (c < chain.length) {
            license = AbstractChainedReasoner.concatenate(license, chain[c].getLicense());
            licenseRestriction = AbstractChainedReasoner.concatenate(licenseRestriction, chain[c].getLicenseRestriction());
            ++c;
        }
        DerivedReasonerDescriptor result = new DerivedReasonerDescriptor(name, version, license, licenseRestriction);
        int c2 = 0;
        while (c2 < chain.length) {
            result.addCapabilities(chain[c2]);
            ++c2;
        }
        return result;
    }

    private static String concatenate(String s1, String s2) {
        Object result = s1;
        if (s2 != null) {
            if (((String)result).length() > 0) {
                result = (String)result + "\n";
            }
            result = (String)result + s2;
        }
        return result;
    }

    @Override
    public ReasoningResult upgrade(URI url, ProgressObserver observer) {
        return null;
    }

    @Override
    public ReasonerDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ReasoningResult isConsistent(Project project, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        int r = 0;
        while ((this.reasoningResult == null || this.reasoningResult.hasConflict()) && r < this.reasoners.length) {
            IChainingReasoner reasoner = this.reasoners[r];
            reasoner.setState(this.config, this.reasoningResult);
            this.reasoningResult = reasoner.isConsistent(project, reasonerConfiguration, observer);
            this.config = this.reasoners[r].getLastConfiguration();
            ++r;
        }
        ReasoningResult result = this.reasoningResult;
        this.reasoningResult = null;
        return result;
    }

    @Override
    public ReasoningResult check(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        if (this.config == null) {
            this.config = cfg;
        }
        int r = 0;
        while ((this.reasoningResult == null || this.reasoningResult.hasConflict()) && r < this.reasoners.length) {
            IChainingReasoner reasoner = this.reasoners[r];
            reasoner.setState(this.config, this.reasoningResult);
            this.reasoningResult = reasoner.check(this.config, reasonerConfiguration, observer);
            this.config = this.reasoners[r].getLastConfiguration();
            ++r;
        }
        ReasoningResult result = this.reasoningResult;
        this.reasoningResult = null;
        return result;
    }

    @Override
    public ReasoningResult propagate(Configuration cfg, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        if (this.config == null) {
            this.config = cfg;
        }
        int r = 0;
        while ((this.reasoningResult == null || this.reasoningResult.hasConflict()) && r < this.reasoners.length) {
            IChainingReasoner reasoner = this.reasoners[r];
            reasoner.setState(this.config, this.reasoningResult);
            this.reasoningResult = reasoner.propagate(this.config, reasonerConfiguration, observer);
            this.config = this.reasoners[r].getLastConfiguration();
            ++r;
        }
        ReasoningResult result = this.reasoningResult;
        this.reasoningResult = null;
        return result;
    }

    @Override
    public EvaluationResult evaluate(Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        if (this.config == null) {
            this.config = cfg;
        }
        int r = 0;
        while ((this.evaluationResult == null || this.evaluationResult.hasConflict()) && r < this.reasoners.length) {
            IChainingReasoner reasoner = this.reasoners[r];
            reasoner.setState(this.config, this.evaluationResult);
            this.evaluationResult = reasoner.evaluate(this.config, constraints, reasonerConfiguration, observer);
            this.config = this.reasoners[r].getLastConfiguration();
            ++r;
        }
        EvaluationResult result = this.evaluationResult;
        this.evaluationResult = null;
        return result;
    }

    @Override
    public void notify(IReasonerMessage message) {
        int r = 0;
        while (r < this.reasoners.length) {
            this.reasoners[r].notify(message);
            ++r;
        }
    }

    @Override
    public IReasonerInstance createInstance(Configuration cfg, ReasonerConfiguration reasonerConfiguration) {
        return new DelegatingReasonerInstance(cfg, reasonerConfiguration, this);
    }

    @Override
    public void setState(Configuration config, ReasoningResult result) {
        this.config = config;
        this.reasoningResult = result;
    }

    @Override
    public void setState(Configuration config, EvaluationResult result) {
        this.config = config;
        this.evaluationResult = result;
    }

    @Override
    public Configuration getLastConfiguration() {
        Configuration result = this.config;
        this.config = null;
        return result;
    }

    private static class DerivedReasonerDescriptor
    extends ReasonerDescriptor {
        public DerivedReasonerDescriptor(String name, String version, String license, String licenseRestriction) {
            super(name, version, license, licenseRestriction, null);
        }

        private void addCapabilities(ReasonerDescriptor desc) {
            IReasonerCapability[] cap = desc.getCapabilities();
            int c = 0;
            while (c < cap.length) {
                this.addCapability(cap[c]);
                ++c;
            }
        }
    }
}

