/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.performance;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;

public class PerformanceStatistics {
    private static final Map<String, List<Long>> PERFORMANCE = new HashMap<String, List<Long>>();
    private static final Map<String, String> DESCRIPTION = new HashMap<String, String>();
    private static final Map<String, String> PROJECT = new HashMap<String, String>();
    private static final String FOLDER_PATH = "C:/Sizonenko/ReasoningOutput/";
    private static final String LINEBREAK = "\r\n";

    public static synchronized String createReasoningID(String projectName, String description) {
        String reasoningID = projectName;
        DESCRIPTION.put(reasoningID, description);
        PROJECT.put(reasoningID, projectName);
        return reasoningID;
    }

    public static void clearReasoningID(String reasoningID) {
        PERFORMANCE.remove(reasoningID);
        DESCRIPTION.remove(reasoningID);
        PROJECT.remove(reasoningID);
    }

    public static void createPerformanceMeasurement(String reasoningID) {
        PERFORMANCE.put(reasoningID, new ArrayList());
    }

    public static void addTimestamp(String reasoningID) {
        List<Long> timeStamps = PERFORMANCE.get(reasoningID);
        timeStamps.add(System.currentTimeMillis());
    }

    public static void getStats(String reasoningID) {
        List<Long> timeStamps = PERFORMANCE.get(reasoningID);
        if (timeStamps.size() > 0) {
            String fileName = "C:/Sizonenko/ReasoningOutput/Stats.txt";
            FileWriter writer = null;
            try {
                writer = new FileWriter(fileName, true);
                Long generalTime = timeStamps.get(timeStamps.size() - 1) - timeStamps.get(0);
                writer.write(reasoningID + ";" + DESCRIPTION.get(reasoningID) + ";" + String.valueOf(generalTime) + ";");
                int i = 1;
                while (i < timeStamps.size()) {
                    Long calculatedTime = timeStamps.get(i) - timeStamps.get(i - 1);
                    writer.write(String.valueOf(calculatedTime) + ";");
                    ++i;
                }
                writer.write(LINEBREAK);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void printConfigVariables(String reasoningID, Configuration config) {
        String fileName = FOLDER_PATH + reasoningID + "_" + DESCRIPTION.get(reasoningID) + ".txt";
        int linecounter = 0;
        FileWriter writer = null;
        try {
            writer = new FileWriter(fileName, false);
            for (IDecisionVariable variable : config) {
                writer.write(variable.getDeclaration().getName().toString() + ";" + variable.getState().toString() + ";");
                if (variable.hasValue()) {
                    writer.write(variable.getValue().getValue().toString());
                }
                if (++linecounter >= config.getDecisionCount()) continue;
                writer.write(LINEBREAK);
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

