/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.reasoning.core.reasoner.AttributeException;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class AttributeValues {
    private Map<Attribute, List<Value>> valueAssignments = new HashMap<Attribute, List<Value>>();
    private Map<String, List<String>> unresolvedAssignments;

    public void setValue(Attribute attribute, Value value, int index) throws AttributeException {
        List<Value> values = this.valueAssignments.get(attribute);
        if (values == null) {
            throw new AttributeException("attribute does not exist in this value set");
        }
        if (!attribute.getType().isAssignableFrom(value.getType())) {
            throw new AttributeException("given value does not match the type of the attribute");
        }
        values.set(index, value);
    }

    public void addValue(Attribute attribute, Value value) throws AttributeException {
        List<Value> values = this.valueAssignments.get(attribute);
        if (values == null) {
            values = new ArrayList<Value>();
            this.valueAssignments.put(attribute, values);
        }
        if (!values.contains(value)) {
            if (value == null || attribute.getType().isAssignableFrom(value.getType())) {
                values.add(value);
            } else {
                throw new AttributeException("given value does not match the type of the attribute");
            }
        }
    }

    public void removeValue(Attribute attribute, Value value) {
        List<Value> values = this.valueAssignments.get(attribute);
        if (values != null) {
            values.remove(value);
        }
    }

    public int getAttributesCount() {
        return this.valueAssignments.size();
    }

    public Iterator<Attribute> getAttributes() {
        return this.valueAssignments.keySet().iterator();
    }

    public List<Attribute> getAttributesAsList() {
        ArrayList<Attribute> result = new ArrayList<Attribute>(this.valueAssignments.size());
        result.addAll(this.valueAssignments.keySet());
        return result;
    }

    public Set<Attribute> getAttributesAsSet() {
        HashSet<Attribute> result = new HashSet<Attribute>(this.valueAssignments.size());
        result.addAll(this.valueAssignments.keySet());
        return result;
    }

    public int getAttributeValuesCount(Attribute attribute) {
        List<Value> values = this.valueAssignments.get(attribute);
        int result = values != null ? values.size() : -1;
        return result;
    }

    public Value getAttributeValue(Attribute attribute, int index) {
        List<Value> values = this.valueAssignments.get(attribute);
        Value result = values != null ? values.get(index) : null;
        return result;
    }

    public boolean hasValue(AbstractVariable attribute, Value value) {
        boolean result = false;
        List<Value> values = this.valueAssignments.get(attribute);
        if (values != null) {
            result = values.contains(value);
        }
        return result;
    }

    public void clear() {
        this.valueAssignments.clear();
    }

    public boolean isEmpty() {
        return this.valueAssignments.isEmpty();
    }

    public static boolean isEmpty(AttributeValues values) {
        return values == null || values.isEmpty();
    }

    public void setValues(Attribute target, Attribute source) {
        List<Value> sourceValues = this.valueAssignments.get(source);
        List<Value> targetValues = this.valueAssignments.get(target);
        if (targetValues == null) {
            if (sourceValues != null) {
                targetValues = new ArrayList<Value>();
                targetValues.addAll(sourceValues);
                this.valueAssignments.put(target, targetValues);
            }
        } else if (sourceValues == null) {
            this.valueAssignments.remove(target);
        } else {
            targetValues.clear();
            targetValues.addAll(sourceValues);
        }
    }

    public boolean contains(Attribute attribute) {
        return this.valueAssignments.containsKey(attribute);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<Attribute, List<Value>>> iter = this.valueAssignments.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Attribute, List<Value>> entry = iter.next();
            result.append(entry.getKey().getName());
            result.append("={");
            if (entry.getValue() != null) {
                Iterator<Value> valIter = entry.getValue().iterator();
                while (valIter.hasNext()) {
                    result.append(valIter.next());
                    if (!valIter.hasNext()) continue;
                    result.append(", ");
                }
            }
            result.append("}");
            if (!iter.hasNext()) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public void resolveUsing(Project project, boolean clear) throws AttributeException {
        if (this.unresolvedAssignments != null) {
            ResolutionVisitor vis = new ResolutionVisitor();
            project.accept((IModelVisitor)vis);
            String errors = vis.getErrors();
            if (errors.length() == 0) {
                if (clear) {
                    this.valueAssignments = vis.getAssignments();
                } else {
                    this.valueAssignments.putAll(vis.getAssignments());
                }
                this.unresolvedAssignments = null;
            } else {
                throw new AttributeException(errors);
            }
        }
    }

    private static void appendError(StringBuilder builder, String text) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(text);
    }

    public void addUnresolved(String attribute, List<String> values) {
        if (this.unresolvedAssignments == null) {
            this.unresolvedAssignments = new HashMap<String, List<String>>();
        }
        int size = values.size();
        ArrayList<String> valuesCopy = new ArrayList<String>(size);
        int v = 0;
        while (v < size) {
            valuesCopy.add(values.get(v));
            ++v;
        }
        this.unresolvedAssignments.put(attribute, valuesCopy);
    }

    public static String toString(Value value) {
        int pos;
        String result = StringProvider.toIvmlString((Value)value);
        if (value instanceof EnumValue && (pos = result.lastIndexOf(46)) > 0) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    private class ResolutionVisitor
    implements IModelVisitor {
        private Map<Attribute, List<Value>> assignments = new HashMap<Attribute, List<Value>>();
        private StringBuilder errors = new StringBuilder();

        private ResolutionVisitor() {
        }

        public Map<Attribute, List<Value>> getAssignments() {
            return this.assignments;
        }

        public String getErrors() {
            return this.errors.toString();
        }

        public void visitEnum(Enum eenum) {
        }

        public void visitOrderedEnum(OrderedEnum eenum) {
        }

        public void visitCompound(Compound compound) {
            int e = 0;
            while (e < compound.getDeclarationCount()) {
                compound.getDeclaration(e).accept((IModelVisitor)this);
                ++e;
            }
        }

        public void visitDerivedDatatype(DerivedDatatype datatype) {
        }

        public void visitEnumLiteral(EnumLiteral literal) {
        }

        public void visitReference(Reference reference) {
        }

        public void visitSequence(Sequence sequence) {
        }

        public void visitSet(net.ssehub.easy.varModel.model.datatypes.Set set) {
        }

        public void visitProject(Project project) {
            this.resolve((IAttributableElement)project);
            int e = 0;
            while (e < project.getElementCount()) {
                project.getElement(e).accept((IModelVisitor)this);
                ++e;
            }
        }

        public void visitProjectImport(ProjectImport pImport) {
        }

        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            this.resolve((IAttributableElement)decl);
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitConstraint(Constraint constraint) {
        }

        public void visitFreezeBlock(FreezeBlock freeze) {
        }

        public void visitOperationDefinition(OperationDefinition opdef) {
        }

        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        }

        public void visitProjectInterface(ProjectInterface iface) {
        }

        public void visitComment(Comment comment) {
        }

        public void visitAttributeAssignment(AttributeAssignment assignment) {
            int e = 0;
            while (e < assignment.getElementCount()) {
                assignment.getElement(e).accept((IModelVisitor)this);
                ++e;
            }
        }

        private void resolve(IAttributableElement elt) {
            for (Map.Entry<String, List<String>> entry : AttributeValues.this.unresolvedAssignments.entrySet()) {
                Attribute attr = elt.getAttribute(entry.getKey());
                if (attr != null) {
                    ArrayList<Value> valList = new ArrayList<Value>();
                    for (String value : entry.getValue()) {
                        try {
                            valList.add(ValueFactory.createValue((IDatatype)attr.getType(), (Object[])new Object[]{value}));
                        }
                        catch (ValueDoesNotMatchTypeException e) {
                            AttributeValues.appendError(this.errors, e.getMessage());
                        }
                    }
                    this.assignments.put(attr, valList);
                    continue;
                }
                AttributeValues.appendError(this.errors, "attribute '" + entry.getKey() + "' not found");
            }
        }

        public void visitCompoundAccessStatement(CompoundAccessStatement access) {
        }
    }
}

