/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.varModel.model.Constraint;

public class ConstraintBase
extends ConstraintList {
    private Map<Constraint, ConstraintList.Node> mapping = new HashMap<Constraint, ConstraintList.Node>();

    public ConstraintBase() {
        this.setModificationListener(new ConstraintList.IModificationListener(){

            @Override
            public void notifyRemoved(Constraint constraint, ConstraintList.Node node) {
                ConstraintBase.this.mapping.remove(constraint);
            }

            @Override
            public void notifyAdded(Constraint constraint, ConstraintList.Node node) {
                ConstraintBase.this.mapping.put(constraint, node);
            }

            @Override
            public void notifyRemovedAll() {
                ConstraintBase.this.mapping.clear();
            }
        });
    }

    @Override
    public boolean contains(Constraint constraint) {
        return this.mapping.containsKey(constraint);
    }

    @Override
    public boolean removeAll(Collection<? extends Constraint> constraints) {
        Objects.requireNonNull(constraints);
        boolean modified = false;
        Iterator<? extends Constraint> it = constraints.iterator();
        while (it.hasNext()) {
            ConstraintList.Node node = this.mapping.get(it.next());
            if (node == null) continue;
            this.unlink(node);
            modified = true;
        }
        return modified;
    }
}

