/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.yaml;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;

public class YamlDeserializer {
    private String originalFile;

    private YamlDeserializer() {
    }

    public static YamlDeserializer getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public Map<Object, Object> loadFile(File file) throws IOException {
        FileInputStream input;
        Yaml yaml;
        HashMap<Object, Object> ret;
        if (this.originalFile == null) {
            this.originalFile = this.readOriginalFile(file);
        }
        ret = (ret = (HashMap<Object, Object>)(yaml = new Yaml()).load((Reader)new InputStreamReader(input = new FileInputStream(file)))) != null ? new HashMap<Object, Object>(ret) : null;
        try {
            ((InputStream)input).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void createBackup(File file) throws IOException {
        File dest = new File(file.getParentFile().getAbsolutePath(), file.getName() + "_backup");
        FileUtils.copyFile((File)file, (File)dest);
    }

    private String readOriginalFile(File file) throws IOException {
        String fileAsString = "";
        try (FileInputStream inputStream = new FileInputStream(file);){
            fileAsString = IOUtils.toString((InputStream)inputStream);
        }
        return fileAsString;
    }

    public String getOriginalFile() {
        return this.originalFile;
    }

    private Session createSession(String user, String password, String host) throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(user, host, 22);
        session.setPassword(password);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        return session;
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    private static final class InstanceHolder {
        static final YamlDeserializer INSTANCE = new YamlDeserializer();

        private InstanceHolder() {
        }
    }
}

