/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.yaml;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.ssehub.easy.instantiation.yaml.YamlDeserializer;

public class YamlEditor {
    private Map<Object, Object> data;

    private YamlEditor() {
    }

    public static YamlEditor getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void updateEntry(File file, Object key, Object value) throws IOException {
        if (this.data == null) {
            this.data = YamlDeserializer.getInstance().loadFile(file);
        }
        this.data.put(key, value);
    }

    public Object getEntry(Object key, File file) throws IOException {
        if (this.data == null) {
            this.data = YamlDeserializer.getInstance().loadFile(file);
        }
        return this.data.get(key);
    }

    public Map<Object, Object> getData() {
        return this.data;
    }

    public void refreshData(File file) throws IOException {
        this.data = YamlDeserializer.getInstance().loadFile(file);
    }

    private static final class InstanceHolder {
        static final YamlEditor INSTANCE = new YamlEditor();

        private InstanceHolder() {
        }
    }
}

