/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.Formatting;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.yaml.INodeParent;
import net.ssehub.easy.instantiation.yaml.YamlArtifactCreator;
import net.ssehub.easy.instantiation.yaml.YamlNode;
import net.ssehub.easy.instantiation.yaml.YamlStructure;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

@ArtifactCreator(value=YamlArtifactCreator.class)
public class YamlFileArtifact
extends FileArtifact
implements IStringValueProvider,
INodeParent {
    private List<YamlNode> data = new ArrayList<YamlNode>();
    private boolean changedByNodes = false;

    public YamlFileArtifact() {
    }

    protected YamlFileArtifact(File file, ArtifactModel model) {
        super(file, model);
        this.initialize();
    }

    private void initialize() {
        File f = this.getPath().getAbsolutePath();
        try {
            this.data.clear();
            if (f.exists()) {
                Yaml yaml = new Yaml();
                FileInputStream fis = new FileInputStream(f);
                for (Object document : yaml.loadAll((InputStream)fis)) {
                    this.data.add(new YamlNode(document, (INodeParent)this));
                }
                fis.close();
            }
        }
        catch (Throwable e) {
            EASyLoggerFactory.INSTANCE.getLogger(YamlFileArtifact.class, "net.ssehub.easy.instantiation.yaml").warn("While reading " + String.valueOf(f) + ": " + e.getMessage());
        }
    }

    public void artifactChanged(Object cause) throws VilException {
        super.artifactChanged(cause);
        this.initialize();
    }

    public static YamlFileArtifact create() {
        return new YamlFileArtifact();
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(String val) throws VilException {
        Path path = Path.convert((String)val);
        return (FileArtifact)ArtifactFactory.createArtifact(YamlFileArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    @Invisible
    @Conversion
    public static YamlFileArtifact convert(IFileSystemArtifact val) {
        YamlFileArtifact convertedValue = null;
        if (val instanceof YamlFileArtifact) {
            convertedValue = (YamlFileArtifact)val;
        } else if (val instanceof FileArtifact) {
            FileArtifact fa = (FileArtifact)val;
            try {
                convertedValue = (YamlFileArtifact)ArtifactFactory.createArtifact(YamlFileArtifact.class, (Object)fa.getPath().getAbsolutePath(), null);
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(YamlFileArtifact.class, "net.ssehub.easy.instantiation.yaml").error(e.getMessage());
            }
        }
        return convertedValue;
    }

    public YamlNode addDocument() {
        YamlNode current = new YamlNode(this);
        this.data.add(current);
        this.notifyChanged();
        return current;
    }

    public YamlNode addDocument(boolean onlyIfEmpty) {
        YamlNode result = this.data.isEmpty() ? this.addDocument() : this.data.get(0);
        return result;
    }

    public YamlNode addDocument(YamlNode node) {
        this.data.add(node);
        node.setParent(this);
        this.notifyChanged();
        return node;
    }

    public int getDocumentCount() {
        return this.data.size();
    }

    public YamlNode getDocument(int index) {
        return this.data.get(index);
    }

    public void deleteDocument(int index) {
        this.data.remove(index);
        this.notifyChanged();
    }

    public synchronized void deleteAllDocuments() {
        boolean hadContents = !this.data.isEmpty();
        this.data.clear();
        if (hadContents) {
            this.notify();
        }
    }

    private DumperOptions createDumperOptions() {
        DumperOptions options = new DumperOptions();
        IndentationConfiguration iCfg = Formatting.getIndentationConfiguration();
        FormattingConfiguration fCfg = Formatting.getFormattingConfiguration();
        DumperOptions.FlowStyle flowStyle = DumperOptions.FlowStyle.BLOCK;
        try {
            flowStyle = DumperOptions.FlowStyle.valueOf((String)fCfg.getProfileArgument("flowStyle", "BLOCK"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        options.setDefaultFlowStyle(flowStyle);
        DumperOptions.ScalarStyle scalarStyle = DumperOptions.ScalarStyle.PLAIN;
        try {
            scalarStyle = DumperOptions.ScalarStyle.valueOf((String)fCfg.getProfileArgument("scalarStyle", "PLAIN"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        options.setDefaultScalarStyle(scalarStyle);
        int indent = 1;
        if (fCfg.getIndentSteps() > 0) {
            indent = fCfg.getIndentSteps();
        } else if (iCfg.getIndentationStep() > 0) {
            indent = iCfg.getIndentationStep();
        }
        int indicatorIndent = indent - 1;
        try {
            indicatorIndent = Integer.parseInt(fCfg.getProfileArgument("indicatorIndent", String.valueOf(indicatorIndent)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        options.setIndent(indent);
        if (indicatorIndent >= 0 && indicatorIndent < indent) {
            options.setIndicatorIndent(indicatorIndent);
        }
        options.setPrettyFlow(Boolean.valueOf(fCfg.getProfileArgument("prettyFlow", "true")).booleanValue());
        return options;
    }

    public void store() throws VilException {
        super.store();
        if (this.changedByNodes) {
            try {
                File file = this.getPath().getAbsolutePath();
                file.getParentFile().mkdirs();
                FileWriter writer = new FileWriter(file);
                FormattingConfiguration fCfg = Formatting.getFormattingConfiguration();
                YamlStructure.Sorting sorting = YamlStructure.Sorting.INSERT;
                try {
                    sorting = YamlStructure.Sorting.valueOf(fCfg.getProfileArgument("sorting", YamlStructure.Sorting.NONE.name()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                DumperOptions options = this.createDumperOptions();
                Representer representer = new Representer(options);
                Yaml yaml = new Yaml(representer, options);
                boolean first = true;
                for (YamlNode node : this.data) {
                    Object d;
                    if (!first) {
                        writer.append("--\n");
                    }
                    if (!(d = node.getData(sorting)).isEmpty()) {
                        yaml.dump(d, (Writer)writer);
                    }
                    first = false;
                }
                writer.close();
                this.changedByNodes = false;
            }
            catch (IOException e) {
                throw new VilException(e.getMessage(), (Throwable)e, 50001);
            }
        }
    }

    @Override
    public void notifyChanged() {
        this.changedByNodes = true;
    }
}

