/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.yaml;

import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.yaml.ClassMap;
import net.ssehub.easy.instantiation.yaml.INodeParent;
import net.ssehub.easy.instantiation.yaml.YamlList;
import net.ssehub.easy.instantiation.yaml.YamlStructure;

public class YamlNode
extends YamlStructure {
    private java.util.Map<String, Object> data;
    private List<String> sequence = new ArrayList<String>();

    YamlNode(INodeParent parent) {
        super(parent);
        this.data = new HashMap<String, Object>();
    }

    YamlNode(java.util.Map<String, Object> data, INodeParent parent) {
        super(parent);
        this.data = data;
    }

    YamlNode(Object data, INodeParent parent) {
        this(parent);
        if (data instanceof java.util.Map) {
            java.util.Map value = (java.util.Map)data;
            for (Object key : value.keySet()) {
                Object val = value.get(key);
                this.set(key.toString(), val, false);
            }
        }
    }

    private void set(String key, Object val, boolean notify) {
        if (this.data.put(key, IVilType.convertVilValue((Object)val)) == null) {
            this.sequence.add(key);
        }
        if (notify) {
            this.notifyChanged();
        }
    }

    public static YamlNode create() {
        return new YamlNode(null);
    }

    public boolean has(String name) {
        return this.data.containsKey(name);
    }

    public YamlNode addValue(String name, Object value) {
        this.set(name, value, true);
        return this;
    }

    public YamlNode addValueNotEmpty(String name, Object value) {
        boolean add = true;
        if (value instanceof String) {
            boolean bl = add = !((String)value).isEmpty();
        }
        if (add) {
            this.addValue(name, value);
        }
        return this;
    }

    public YamlNode addValueOrNone(String name, Object value) {
        boolean add = true;
        if (value instanceof String && ((String)value).isEmpty()) {
            value = null;
        }
        if (add) {
            this.addValue(name, value);
        }
        return this;
    }

    public YamlNode addObject(String name) {
        YamlNode node = new YamlNode(new ClassMap(), (INodeParent)this);
        this.set(name, node, true);
        return node;
    }

    public YamlNode addObjects(String path, String separators) {
        YamlNode result = this;
        StringTokenizer tokens = new StringTokenizer(path, separators);
        while (tokens.hasMoreTokens()) {
            result = result.addObject(tokens.nextToken());
        }
        return result;
    }

    public YamlNode delete(String name) {
        this.data.remove(name);
        this.sequence.remove(name);
        this.notifyChanged();
        return this;
    }

    public Object getValue(String name) {
        return this.data.get(name);
    }

    public YamlNode getObject(String name) {
        return this.isObject(name) ? new YamlNode((Map)this.data.get(name), (INodeParent)this) : null;
    }

    public boolean isObject(String name) {
        return this.data.get(name) instanceof Map;
    }

    public Sequence<Object> getListValue(String name) {
        ListSequence result = null;
        if (this.isList(name)) {
            List tmp = (List)this.data.get(name);
            result = new ListSequence(tmp, new TypeDescriptor[]{TypeRegistry.anyType()});
        }
        return result;
    }

    public YamlList getList(String name) {
        YamlList result = null;
        if (this.isList(name)) {
            Object d = this.data.get(name);
            result = d instanceof YamlList ? (YamlList)d : new YamlList((List)d, this);
        }
        return result;
    }

    public boolean isList(String name) {
        return this.data.get(name) instanceof List;
    }

    public Map<String, Object> getMapValue(String name) {
        Map result = null;
        if (this.isList(name)) {
            java.util.Map tmp = (java.util.Map)this.data.get(name);
            TypeDescriptor[] types = TypeDescriptor.createArray((int)2);
            types[0] = TypeRegistry.stringType();
            types[1] = TypeRegistry.anyType();
            result = new Map(tmp, types);
        }
        return result;
    }

    public YamlNode getMap(String name) {
        YamlNode result = null;
        if (this.isList(name)) {
            Object d = this.data.get(name);
            if (d instanceof YamlNode) {
                result = (YamlNode)d;
            } else if (d instanceof Map) {
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                for (Map.Entry e : ((java.util.Map)d).entrySet()) {
                    tmp.put(e.getKey().toString(), e.getValue());
                }
                result = new YamlNode(tmp, (INodeParent)this);
            }
        }
        return result;
    }

    public boolean isMap(String name) {
        return this.data.get(name) instanceof Map;
    }

    public YamlList addList(String name) {
        YamlList result = this.getList(name);
        if (result == null) {
            result = new YamlList(new ArrayList<Object>(), this);
            this.set(name, result, true);
        }
        return result;
    }

    public YamlNode addList(String name, Sequence<?> value) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Object o : value) {
            tmp.add(IVilType.convertVilValue(o));
        }
        this.set(name, tmp, true);
        return this;
    }

    public YamlNode addListNotEmpty(String name, Sequence<?> value) {
        if (value.size() > 0) {
            this.addList(name, value);
        }
        return this;
    }

    public YamlNode addValues(Map<?, ?> value) {
        for (Object key : value.keys()) {
            Object val = value.get(key);
            this.set(key.toString(), val, false);
        }
        this.notifyChanged();
        return this;
    }

    public YamlNode addMap(String name) {
        YamlNode result = this.getMap(name);
        if (result == null) {
            result = new YamlNode(this);
            this.set(name, result, true);
        }
        return result;
    }

    public YamlNode addMap(String name, Map<?, ?> value) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        for (Object key : value.keys()) {
            Object val = IVilType.convertVilValue((Object)value.get(key));
            tmp.put(key.toString(), val);
        }
        this.set(name, tmp, true);
        return this;
    }

    @Override
    @Invisible
    java.util.Map<String, Object> getData(YamlStructure.Sorting sorting) {
        AbstractMap result = switch (sorting) {
            case YamlStructure.Sorting.INSERT -> {
                HashMap<String, Integer> seq = new HashMap<String, Integer>();
                int i = 0;
                while (i < this.sequence.size()) {
                    seq.put(this.sequence.get(i), i);
                    ++i;
                }
                yield new TreeMap((f1, f2) -> Integer.compare((Integer)seq.get(f1), (Integer)seq.get(f2)));
            }
            case YamlStructure.Sorting.ALPHA -> new TreeMap((f1, f2) -> f1.compareTo((String)f2));
            case YamlStructure.Sorting.COLLATOR -> new TreeMap(Collator.getInstance());
            default -> new HashMap();
        };
        for (String key : this.data.keySet()) {
            Object value = this.data.get(key);
            if (value instanceof YamlStructure) {
                YamlStructure valueNode = (YamlStructure)value;
                value = valueNode.hasData() ? valueNode.getData(sorting) : null;
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    @Invisible
    boolean hasData() {
        return this.data != null && this.data.size() > 0;
    }

    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return comparator != null ? "YamlNode" : this.data.toString();
    }
}

