/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.java.artifacts.IJavaParent;
import net.ssehub.easy.instantiation.java.artifacts.InvocationRemovalVisitor;
import net.ssehub.easy.instantiation.java.artifacts.JavaAnnotation;
import net.ssehub.easy.instantiation.java.artifacts.JavaAttribute;
import net.ssehub.easy.instantiation.java.artifacts.JavaFileArtifact;
import net.ssehub.easy.instantiation.java.artifacts.JavaMethod;
import net.ssehub.easy.instantiation.java.artifacts.JavaParentFragmentArtifact;
import net.ssehub.easy.instantiation.java.artifacts.JavaQualifiedName;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class JavaClass
extends JavaParentFragmentArtifact {
    private TypeDeclaration typeDeclaration;

    public JavaClass(TypeDeclaration typeDeclaration, IJavaParent parent) {
        super(parent);
        this.typeDeclaration = typeDeclaration;
    }

    @Override
    public void delete() throws VilException {
        super.delete();
    }

    public String getName() throws VilException {
        return this.typeDeclaration.getName().getIdentifier();
    }

    public void rename(String name) throws VilException {
        this.notifyChanged();
    }

    public Text getText() throws VilException {
        return Text.CONSTANT_EMPTY;
    }

    public Binary getBinary() throws VilException {
        return Binary.CONSTANT_EMPTY;
    }

    public void accept(IArtifactVisitor visitor) {
        visitor.visitFragmentArtifact((FragmentArtifact)this);
    }

    @ReturnGenerics(value={JavaAnnotation.class})
    public Set<JavaAnnotation> annotations() {
        return this.annotations(this.typeDeclaration.modifiers());
    }

    @ReturnGenerics(value={JavaMethod.class})
    public Set<JavaMethod> methods() {
        final ArrayList list = new ArrayList();
        this.typeDeclaration.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                JavaMethod method = new JavaMethod(node, JavaClass.this);
                list.add(method);
                return false;
            }
        });
        return new ArraySet((Object[])list.toArray(new JavaMethod[list.size()]), JavaMethod.class);
    }

    @ReturnGenerics(value={JavaMethod.class})
    public Set<JavaMethod> methodsByAnnotation(String annotation) {
        return this.methodsByAnnotation(annotation, null, null);
    }

    @ReturnGenerics(value={JavaMethod.class})
    public Set<JavaMethod> methodsByAnnotation(String annotation, String field, Object value) {
        Set<JavaMethod> res = this.methods();
        for (JavaMethod m : res.asSequence()) {
            if (JavaClass.matchesAnnotation(m.annotations(), annotation, field, value)) continue;
            res.remove((Object)m);
        }
        return res;
    }

    private static boolean matchesAnnotation(Set<JavaAnnotation> annotations, String annotation, String field, Object value) {
        boolean matches = false;
        String sValue = value == null ? null : value.toString();
        for (JavaAnnotation an : annotations) {
            try {
                if (!an.getName().equals(annotation)) continue;
                if (field != null) {
                    String val = an.getAnnotationValue(field);
                    matches = val != null && val.equals(sValue);
                    continue;
                }
                matches = true;
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return matches;
    }

    public void deleteStatement(ExpressionEvaluator evaluator) throws VilException {
        for (JavaMethod method : this.methods()) {
            method.deleteStatement(evaluator);
        }
    }

    public void deleteMethodWithCalls(ExpressionEvaluator evaluator) throws VilException {
        this.deleteMethodWithCalls(evaluator, null);
    }

    public void deleteMethodWithCalls(ExpressionEvaluator evaluator, Object replacement) throws VilException {
        for (JavaMethod method : this.methods()) {
            Object object = evaluator.evaluate((Object)method);
            if (object == null || !(object instanceof Boolean) || Boolean.TRUE.booleanValue() != ((Boolean)object).booleanValue()) continue;
            Set allFileArtifacts = this.getArtifactModel().selectByType(JavaFileArtifact.class, false);
            for (FileArtifact fileArtifact : allFileArtifacts) {
                JavaFileArtifact javaFileArtifact = (JavaFileArtifact)fileArtifact;
                for (JavaClass javaClass : javaFileArtifact.classes()) {
                    for (JavaMethod javaMethod : javaClass.methods()) {
                        InvocationRemovalVisitor visitor = new InvocationRemovalVisitor(method.getMethodDeclaration(), replacement);
                        javaMethod.getMethodDeclaration().accept((ASTVisitor)visitor);
                        if (!visitor.hasBeenDeleted()) continue;
                        javaMethod.notifyChanged();
                        javaMethod.getParent().store();
                    }
                }
            }
            method.delete();
        }
    }

    public Set<JavaClass> classes() {
        final ArrayList list = new ArrayList();
        this.typeDeclaration.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration typeDeclaration) {
                if (!typeDeclaration.isPackageMemberTypeDeclaration()) {
                    list.add(new JavaClass(typeDeclaration, JavaClass.this));
                }
                return true;
            }
        });
        return new ArraySet((Object[])list.toArray(new JavaClass[list.size()]), JavaClass.class);
    }

    @ReturnGenerics(value={JavaAttribute.class})
    public Set<JavaAttribute> attributes() {
        final ArrayList list = new ArrayList();
        this.typeDeclaration.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                String attributeName = "";
                Object object = node.fragments().get(0);
                if (object instanceof VariableDeclarationFragment) {
                    attributeName = ((VariableDeclarationFragment)object).getName().toString();
                }
                JavaAttribute attribute = new JavaAttribute(node, attributeName, JavaClass.this);
                list.add(attribute);
                return false;
            }
        });
        return new ArraySet((Object[])list.toArray(new JavaAttribute[list.size()]), JavaAttribute.class);
    }

    @ReturnGenerics(value={JavaAttribute.class})
    public Set<JavaAttribute> attributesByAnnotation(String annotation) {
        return this.attributesByAnnotation(annotation, null, null);
    }

    @ReturnGenerics(value={JavaAttribute.class})
    public Set<JavaAttribute> attributesByAnnotation(String annotation, String field, Object value) {
        Set<JavaAttribute> res = this.attributes();
        for (JavaAttribute a : res.asSequence()) {
            if (JavaClass.matchesAnnotation(a.annotations(), annotation, field, value)) continue;
            res.remove((Object)a);
        }
        return res;
    }

    public JavaAttribute getAttributeByName(final String name) {
        final JavaAttribute[] tmp = new JavaAttribute[1];
        this.typeDeclaration.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration node) {
                String attributeName = "";
                Object object = node.fragments().get(0);
                if (object instanceof VariableDeclarationFragment) {
                    attributeName = ((VariableDeclarationFragment)object).getName().toString();
                }
                if (tmp[0] == null && attributeName.equals(name)) {
                    tmp[0] = new JavaAttribute(node, attributeName, JavaClass.this);
                }
                return false;
            }
        });
        return tmp[0];
    }

    public Set<JavaQualifiedName> qualifiedNames() {
        final ArrayList list = new ArrayList();
        this.typeDeclaration.accept(new ASTVisitor(){

            public boolean visit(QualifiedName node) {
                list.add(new JavaQualifiedName(node, JavaClass.this));
                return false;
            }
        });
        return new ArraySet((Object[])list.toArray(new JavaQualifiedName[list.size()]), JavaQualifiedName.class);
    }

    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "class '" + this.getNameSafe() + "'";
    }

    @Override
    @Invisible
    public ArtifactModel getArtifactModel() {
        return this.getParent().getArtifactModel();
    }
}

