/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.Formatting;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImport;
import net.ssehub.easy.instantiation.java.codeArtifacts.Storable;

public interface IJavaCodeElement
extends IVilType,
IStringValueProvider,
Storable {
    public static final Comparator<IJavaCodeElement> KEY_COMPARATOR = (e1, e2) -> e1.getSortKey().compareTo(e2.getSortKey());

    public IJavaCodeArtifact getArtifact();

    default public JavaCodeImport addImport(String imp) {
        return this.getArtifact().addImport(imp);
    }

    default public JavaCodeImport addStaticImport(String imp) {
        return this.getArtifact().addStaticImport(imp);
    }

    public IJavaCodeElement getParent();

    @Invisible(inherit=true)
    public void setParent(IJavaCodeElement var1);

    @Invisible(inherit=true)
    default public void addAll(List<IJavaCodeElement> list) {
        list.add(this);
    }

    @Invisible(inherit=true)
    default public boolean hasJavadocComment() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isInitializer() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isAttribute() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isConstructor() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isMethod() {
        return false;
    }

    @Invisible(inherit=true)
    default public String getSortKey() {
        return "";
    }

    @Invisible(inherit=true)
    default public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName();
    }

    @Invisible(inherit=true)
    default public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getTracerStringValue(comparator);
    }

    public static <L, E extends L> E add(List<L> list, E element) {
        list.add(element);
        return element;
    }

    public static <L, E extends L> E add(List<L> list, E element, int pos) {
        list.add(pos, element);
        return element;
    }

    public static String appendWhitespace(String text) {
        if (text.endsWith(" ")) {
            return text;
        }
        return IJavaCodeElement.appendSeparator(text, " ");
    }

    public static String appendSeparator(String text, String separator) {
        if (((String)text).length() > 0) {
            text = (String)text + separator;
        }
        return text;
    }

    public static void storeList(List<? extends IJavaCodeElement> elements, String separator, CodeWriter out) {
        IJavaCodeElement.storeList("", elements, separator, out);
    }

    public static void storeList(String prefix, List<? extends IJavaCodeElement> elements, String separator, CodeWriter out) {
        if (elements != null && elements.size() > 0) {
            if (prefix != null && prefix.length() > 0) {
                out.print(prefix);
            }
            int e = 0;
            while (e < elements.size()) {
                if (e > 0) {
                    out.print(", ");
                }
                elements.get(e).store(out);
                ++e;
            }
        }
    }

    public static String toList(List<String> elements, String separator) {
        Object result = "";
        if (elements != null) {
            int e = 0;
            while (e < elements.size()) {
                if (e > 0) {
                    result = (String)result + ", ";
                }
                result = (String)result + elements.get(e);
                ++e;
            }
        }
        return result;
    }

    public static <T extends IJavaCodeElement> void setParent(IJavaCodeElement parent, Class<T> cls, Consumer<T> setter) {
        if (cls.isInstance(parent)) {
            setter.accept((IJavaCodeElement)cls.cast(parent));
        }
    }

    public static <T extends Enum<T>> T getFormattingArgument(Class<T> cls, String key, T dflt) {
        T result = dflt;
        try {
            result = Enum.valueOf(cls, Formatting.getFormattingConfiguration().getProfileArgument(key, dflt != null ? dflt.name() : ""));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public static void sort(List<IJavaCodeElement> list, Comparator<IJavaCodeElement> comparator) {
        if (comparator != null && list != null && list.size() > 0) {
            Collections.sort(list, comparator);
        }
    }

    public static String escape(String text, Set<Character> escapes, Function<String, String> escapeFunc) {
        Object tmp = "";
        int lastSplit = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (escapes.contains(Character.valueOf(c))) {
                tmp = (String)tmp + escapeFunc.apply(text.substring(lastSplit, i)) + c;
                lastSplit = i + 1;
            }
            ++i;
        }
        if (lastSplit < text.length()) {
            tmp = (String)tmp + escapeFunc.apply(text.substring(lastSplit, text.length()));
        }
        return tmp;
    }

    default public IJavaCodeElement replaceVariable(String oldName, String newName) {
        return this;
    }

    default public IJavaCodeElement replaceMethod(String oldName, String newName) {
        return this;
    }
}

