/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotation;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;

public class JavaCodeAnnotationArgument
implements IJavaCodeElement {
    private String name;
    private JavaCodeExpression value;
    private JavaCodeAnnotation annotation;
    private boolean splitLines;
    private List<JavaCodeExpression> values;

    JavaCodeAnnotationArgument(String name, JavaCodeExpression value, List<JavaCodeExpression> values, boolean splitLines, JavaCodeAnnotation annotation) {
        this.name = name;
        this.annotation = annotation;
        this.splitLines = splitLines;
        this.value = value;
        this.values = values;
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + " (" + (String)(this.hasName() ? this.name + "=" : "") + String.valueOf(this.values != null ? this.values : this.value) + ")";
    }

    public boolean hasName() {
        return this.name != null && this.name.length() > 0;
    }

    @Override
    public void store(CodeWriter out) {
        if (this.hasName()) {
            out.print(this.name);
            out.print(" = ");
        }
        if (this.values != null) {
            boolean split = this.splitLines && this.values.size() > 1;
            boolean first = true;
            out.print("{");
            if (split) {
                out.println();
                out.increaseIndent();
            }
            for (JavaCodeExpression v : this.values) {
                if (!first) {
                    out.print(", ");
                    if (split) {
                        out.println();
                    }
                }
                if (split) {
                    out.printIndent();
                }
                v.store(out);
                first = false;
            }
            if (split) {
                out.decreaseIndent();
            }
            out.print("}");
        } else {
            this.value.store(out);
        }
    }

    @Override
    public int getElementCount() {
        int result = 0;
        if (this.values != null && this.splitLines && this.values.size() > 1) {
            result += this.values.size();
        }
        return result;
    }

    @Override
    public IJavaCodeArtifact getArtifact() {
        return this.annotation.getArtifact();
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.annotation;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        IJavaCodeElement.setParent(parent, JavaCodeAnnotation.class, p -> {
            JavaCodeAnnotation javaCodeAnnotation = this.annotation = p;
        });
    }
}

