/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeConstantExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeLambdaExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStringExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeText;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableDeclaration;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableExpression;

public class JavaCodeArgumentListExpression
extends JavaCodeParsedExpression {
    private List<IJavaCodeElement> arguments = new ArrayList<IJavaCodeElement>();

    protected JavaCodeArgumentListExpression(IJavaCodeElement parent) {
        super(parent);
    }

    public static JavaCodeArgumentListExpression create() {
        return new JavaCodeArgumentListExpression(null);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeArgumentListExpression addArgument(Object arg) {
        String sArg;
        if ((arg = IVilType.convertVilValue((Object)arg)) != null && (sArg = arg.toString()).length() > 0) {
            this.arguments.add(new JavaCodeText(sArg, false, false));
        }
        return this;
    }

    public JavaCodeArgumentListExpression addNullArgument() {
        return this.addArgument("null");
    }

    @OperationMeta(name={"addStringArgument", "stringArg"})
    public JavaCodeArgumentListExpression addStringArgument(String val) {
        return this.addArgument(new JavaCodeStringExpression((IJavaCodeElement)this, val));
    }

    public JavaCodeArgumentListExpression addStringArgumentNotEmpty(String val) {
        if (val != null && val.length() > 0) {
            this.addStringArgument(val);
        }
        return this;
    }

    @OperationMeta(name={"addClassArgument", "classArg"})
    public JavaCodeArgumentListExpression addClassArgument(String cls) {
        JavaCodeTypeSpecification type = JavaCodeTypeSpecification.toClassType(cls, this);
        if (type != null) {
            this.addArgument(new JavaCodeTypeExpression(this, type));
        }
        return this;
    }

    public JavaCodeArgumentListExpression addThisArgument() {
        return this.addArgument("this");
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeArgumentListExpression addArgument(String arg) {
        if (arg != null && arg.length() > 0) {
            this.arguments.add(new JavaCodeText(arg, false, false));
        }
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeArgumentListExpression addArgument(JavaCodeExpression ex) {
        if (ex != null && !ex.isEmpty()) {
            ex.setParent(this);
            this.arguments.add(ex);
        }
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeArgumentListExpression addArgument(JavaCodeVariableDeclaration var) {
        if (var != null) {
            this.arguments.add(new JavaCodeVariableExpression((IJavaCodeElement)this, var));
        }
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeArgumentListExpression addArgument(JavaCodeParameterSpecification param) {
        if (param != null) {
            this.arguments.add(new JavaCodeTextExpression(this, param.getName()));
        }
        return this;
    }

    @OperationMeta(name={"addConstantArgument", "constArg"})
    public JavaCodeArgumentListExpression addConstantArgument(String arg) {
        if (arg != null && arg.length() > 0) {
            this.arguments.add(new JavaCodeConstantExpression(arg, this));
        }
        return this;
    }

    @OperationMeta(name={"addLambdaArgument", "lambdaArg"})
    public JavaCodeLambdaExpression addLambdaArgument() {
        return this.addLambdaArgument(null);
    }

    @OperationMeta(name={"addLambdaArgument", "lambdaArg"})
    public JavaCodeLambdaExpression addLambdaArgument(String variable) {
        return this.addArgumentImpl(new JavaCodeLambdaExpression(this).addVariable(variable));
    }

    @OperationMeta(name={"addArguments", "args"})
    public JavaCodeArgumentListExpression addArguments(JavaCodeArgumentListExpression arguments) {
        this.arguments.addAll(arguments.arguments);
        return this;
    }

    public int getArgumentsCount() {
        return this.arguments.size();
    }

    protected <E extends JavaCodeExpression> E addArgumentImpl(E element) {
        return IJavaCodeElement.add(this.arguments, element);
    }

    @Override
    public void store(CodeWriter out) {
        this.storeArgumentList(out);
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        for (IJavaCodeElement a : this.arguments) {
            JavaCodeArgumentListExpression.setParent(a, this);
        }
    }

    Iterable<IJavaCodeElement> arguments() {
        return this.arguments;
    }

    protected void storeArgumentList(CodeWriter out) {
        IJavaCodeElement.storeList(this.arguments, ",", out);
    }

    @Override
    public JavaCodeArgumentListExpression replaceVariable(String oldName, String newName) {
        this.arguments.forEach(a -> {
            IJavaCodeElement iJavaCodeElement = a.replaceVariable(oldName, newName);
        });
        return this;
    }

    @Override
    public JavaCodeArgumentListExpression replaceMethod(String oldName, String newName) {
        this.arguments.forEach(a -> {
            IJavaCodeElement iJavaCodeElement = a.replaceMethod(oldName, newName);
        });
        return this;
    }
}

