/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.artifacts.JavaFileArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeImport;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArtifactCreator;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeEnum;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImport;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeText;
import net.ssehub.easy.instantiation.java.codeArtifacts.Storable;
import org.apache.commons.lang.StringUtils;

@ArtifactCreator(value=JavaCodeArtifactCreator.class)
public class JavaCodeArtifact
extends FileArtifact
implements IJavaCodeArtifact,
IStringValueProvider,
Storable {
    static final JavaCodeArtifact EMPTY = new JavaCodeArtifact();
    private static final Comparator<IJavaCodeImport> IMPORT_COMPARATOR = (i1, i2) -> i1.getName().compareTo(i2.getName());
    private File file;
    private String packageName;
    private List<IJavaCodeImport> imports = new ArrayList<IJavaCodeImport>();
    private Set<String> importExclusions;
    private List<IJavaCodeElement> elements = new ArrayList<IJavaCodeElement>();
    private String comment;
    private boolean store = true;

    public JavaCodeArtifact() {
        this.store = false;
    }

    protected JavaCodeArtifact(File file, ArtifactModel model) {
        super(file, model);
        this.file = file;
    }

    public static JavaCodeArtifact create() {
        return new JavaCodeArtifact();
    }

    public JavaCodeArtifact disable() {
        this.store = false;
        return this;
    }

    public JavaCodeArtifact enable() {
        this.store = false;
        return this;
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(String val) throws VilException {
        Path path = Path.convert((String)val);
        return (FileArtifact)ArtifactFactory.createArtifact(JavaCodeArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    @Invisible
    @Conversion
    public static JavaCodeArtifact convert(IFileSystemArtifact val) {
        JavaCodeArtifact convertedValue = null;
        if (val instanceof JavaCodeArtifact) {
            convertedValue = (JavaCodeArtifact)val;
        } else if (val instanceof FileArtifact) {
            FileArtifact fa = (FileArtifact)val;
            try {
                convertedValue = (JavaCodeArtifact)ArtifactFactory.createArtifact(JavaCodeArtifact.class, (Object)fa.getPath().getAbsolutePath(), null);
                fa.setEnableContentStore(false);
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(JavaCodeArtifact.class, "net.ssehub.easy.instantiation.java").error(e.getMessage());
            }
        }
        return convertedValue;
    }

    @Invisible
    @Conversion
    public static JavaCodeArtifact convert(Path path) throws VilException {
        return (JavaCodeArtifact)ArtifactFactory.createArtifact(JavaCodeArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    @Invisible
    @Conversion
    public static JavaCodeArtifact convert(JavaFileArtifact val) {
        return JavaCodeArtifact.convert((IFileSystemArtifact)val);
    }

    public Object determineActualValue(Object object) {
        Object result = object;
        if (!(object instanceof JavaCodeArtifact) && object instanceof FileArtifact) {
            result = JavaCodeArtifact.convert((IFileSystemArtifact)object);
        }
        return super.determineActualValue(result);
    }

    public JavaCodeClass addClass(String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeClass(name, this));
    }

    public JavaCodeClass addClass(String name, String comment) {
        return IJavaCodeElement.add(this.elements, new JavaCodeClass(name, this, comment));
    }

    public JavaCodeEnum addEnum(String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeEnum(name, this));
    }

    public JavaCodeEnum addEnum(String name, String comment) {
        return IJavaCodeElement.add(this.elements, new JavaCodeEnum(name, this, comment));
    }

    public JavaCodeArtifact setPackage(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getPackage() {
        return this.packageName;
    }

    @OperationMeta(storeArtifactsBefore=true)
    public void delete() throws VilException {
        super.delete();
    }

    public void add(String text) {
        this.elements.add(new JavaCodeText(text, true, true));
    }

    public void addRaw(String text, boolean indent) {
        this.elements.add(new JavaCodeText(text, indent, true));
    }

    @OperationMeta(name={"comment"})
    public JavaCodeArtifact setComment(String comment) {
        this.comment = comment;
        return this;
    }

    private void storeComment(CodeWriter out) {
        if (this.comment != null) {
            String cmt = this.comment;
            if ((cmt = cmt.replace("\\n", "\n").replace("\\r", "\r")).length() != this.comment.length()) {
                if (!cmt.trim().startsWith("/*")) {
                    String[] lines = cmt.split("\\r?\\n|\\r");
                    out.println("/*");
                    Arrays.stream(lines).forEach(s -> out.println(" * " + s));
                    out.println(" */");
                }
            } else if (!cmt.trim().startsWith("//")) {
                out.println("// " + cmt);
            }
        }
    }

    @Override
    public void store(CodeWriter out) {
        this.storeHeader(out);
        int e = 0;
        while (e < this.elements.size()) {
            if (e > 0) {
                out.println();
            }
            this.elements.get(e).store(out);
            ++e;
        }
    }

    @Override
    public int getElementCount() {
        int result = 0;
        if (this.comment != null) {
            result += 1 + StringUtils.countMatches((String)this.comment, (String)"\\n");
        }
        if (this.hasPackage()) {
            ++result;
        }
        if (!this.imports.isEmpty()) {
            result += this.imports.size() + 1;
        }
        int e = 0;
        while (e < this.elements.size()) {
            result += this.elements.get(e).getElementCount();
            ++e;
        }
        return result += Math.max(0, this.elements.size() - 1);
    }

    protected void storeImports(CodeWriter out) {
        char lastStart = '\u0000';
        for (IJavaCodeImport imp : this.sortImports()) {
            char start = imp.getName().charAt(0);
            if (lastStart != '\u0000' && lastStart != start) {
                out.println();
            }
            imp.store(out);
            lastStart = start;
        }
    }

    public boolean hasPackage() {
        return this.packageName != null && this.packageName.length() > 0;
    }

    protected void storePackage(CodeWriter out) {
        if (this.hasPackage()) {
            out.println("package " + this.packageName + ";");
        }
    }

    protected void storeHeader(CodeWriter out) {
        this.storeComment(out);
        if (this.hasPackage()) {
            this.storePackage(out);
            out.println();
        }
        if (this.imports.size() > 0) {
            this.storeImports(out);
            out.println();
        }
    }

    @Invisible
    public void store() throws VilException {
        if (this.store) {
            CodeWriter out = new CodeWriter(this.file);
            this.store(out);
            out.close();
        }
    }

    @Invisible
    public boolean enableAutoStore() {
        return false;
    }

    @Invisible
    public boolean enableContentStore() {
        return false;
    }

    public String toImports() {
        return Storable.getString(o -> this.storeImports((CodeWriter)o));
    }

    public String toPackage() {
        return Storable.getString(o -> this.storePackage((CodeWriter)o));
    }

    public String toHeader() {
        return Storable.getString(o -> this.storeHeader((CodeWriter)o));
    }

    private List<IJavaCodeImport> sortImports() {
        ArrayList<IJavaCodeImport> javaStatic = new ArrayList<IJavaCodeImport>();
        ArrayList<IJavaCodeImport> restStatic = new ArrayList<IJavaCodeImport>();
        ArrayList<IJavaCodeImport> java = new ArrayList<IJavaCodeImport>();
        ArrayList<IJavaCodeImport> rest = new ArrayList<IJavaCodeImport>();
        for (IJavaCodeImport i : this.imports) {
            if (i.getName().startsWith("java")) {
                if (i.isStatic()) {
                    javaStatic.add(i);
                    continue;
                }
                java.add(i);
                continue;
            }
            if (i.isStatic()) {
                restStatic.add(i);
                continue;
            }
            rest.add(i);
        }
        Collections.sort(javaStatic, IMPORT_COMPARATOR);
        Collections.sort(restStatic, IMPORT_COMPARATOR);
        Collections.sort(java, IMPORT_COMPARATOR);
        Collections.sort(rest, IMPORT_COMPARATOR);
        ArrayList<IJavaCodeImport> result = new ArrayList<IJavaCodeImport>(this.imports.size());
        result.addAll(java);
        result.addAll(rest);
        result.addAll(javaStatic);
        result.addAll(restStatic);
        return result;
    }

    private String removeNonTypeChars(String text) {
        return text.replace("\n", "").replace("\r", "").replace(" ", "");
    }

    @Override
    @Invisible
    public void validateType(IJavaCodeTypeSpecification type) {
        String typeName = type.getOutputTypeName();
        boolean varArg = false;
        if (typeName.endsWith("...")) {
            varArg = true;
            typeName = typeName.substring(0, typeName.length() - "...".length());
        }
        String prefix = "";
        String marker = " super ";
        int pos = typeName.lastIndexOf(marker);
        if (pos < 0) {
            marker = " extends ";
            pos = typeName.lastIndexOf(marker);
        }
        if (pos > 0) {
            prefix = typeName.substring(0, pos += marker.length());
            typeName = typeName.substring(pos);
        }
        String plainTypeName = typeName = this.removeNonTypeChars(typeName);
        pos = typeName.lastIndexOf(46);
        if (pos > 0) {
            String simpleClsName;
            String simpleTypeName = typeName.substring(pos + 1);
            JavaCodeClass cls = JavaCodeClass.getParentCodeClass(type);
            String string = simpleClsName = cls != null ? cls.getName() : "";
            if (!simpleClsName.equals(simpleTypeName) && !this.isExcludedImport(typeName)) {
                Object newOutputTypeName = prefix + simpleTypeName;
                IJavaCodeImport match = this.findMatchingImport(typeName, false);
                if (match == null) {
                    new JavaCodeImport(typeName, this);
                } else if (!plainTypeName.equals(match.getName())) {
                    newOutputTypeName = plainTypeName;
                }
                type.setOutputTypeName((String)newOutputTypeName);
                type.setVarArg(varArg);
            }
        }
    }

    private static boolean seemsToBeClass(String name) {
        return name.length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    @Override
    @Invisible
    public String validateStaticName(String name, JavaCodeImportScope scope) {
        String origName = name;
        int pos = ((String)name).lastIndexOf(46);
        if (pos > 0) {
            String[] parts = ((String)name).split("\\.");
            pos = parts.length - 2;
            while (pos > 0 && parts[pos].endsWith(")")) {
                --pos;
            }
            Object type = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, pos + 1));
            String mName = parts[pos + 1];
            int aPos = mName.indexOf("(");
            if (aPos > 0) {
                mName = mName.substring(0, aPos);
            }
            String qualifiedMethod = (String)type + "." + mName;
            name = String.join((CharSequence)".", Arrays.copyOfRange(parts, pos + 1, parts.length));
            if (scope == JavaCodeImportScope.CLASS_NO_METHOD) {
                type = (String)type + "." + (String)name;
            }
            if (JavaCodeImportScope.CLASS == scope || JavaCodeImportScope.METHOD_CLASS_IMPORT == scope || JavaCodeImportScope.CLASS_NO_METHOD == scope) {
                if (this.isExcludedImport((String)type)) {
                    name = origName;
                } else {
                    IJavaCodeImport imp = this.findMatchingImport((String)type, true);
                    if (imp == null && ((String)type).contains(".")) {
                        new JavaCodeImport((String)type, this, false);
                    }
                    aPos = ((String)type).lastIndexOf(46);
                    Object simpleTypeName = type;
                    if (pos > 0) {
                        simpleTypeName = ((String)type).substring(aPos + 1);
                    }
                    if (JavaCodeImportScope.CLASS == scope || JavaCodeImportScope.METHOD_CLASS_IMPORT == scope && JavaCodeArtifact.seemsToBeClass((String)simpleTypeName)) {
                        name = (String)simpleTypeName + "." + (String)name;
                    }
                }
            } else if (JavaCodeImportScope.METHOD == scope) {
                IJavaCodeImport imp = this.findMatchingImport(qualifiedMethod, true);
                if (imp == null) {
                    imp = this.findMatchingImport((String)type + ".*", true);
                }
                if (imp == null) {
                    new JavaCodeImport(qualifiedMethod, this, true);
                }
            }
        }
        return name;
    }

    private IJavaCodeImport findMatchingImport(String imp, boolean isStatic) {
        IJavaCodeImport result = null;
        String impPrefix = "";
        String impSimpleName = imp;
        int pos = imp.lastIndexOf(46);
        if (pos > 0) {
            impPrefix = imp.substring(0, pos);
            impSimpleName = imp.substring(pos + 1);
        }
        if (JavaCodeImport.DEFAULT.getName().equals(impPrefix)) {
            result = JavaCodeImport.DEFAULT;
        } else {
            for (IJavaCodeImport i : this.imports) {
                if (i.isStatic() != isStatic) continue;
                String iName = i.getName();
                boolean found = false;
                if (i.isWildcard()) {
                    found = impPrefix.equals(iName.substring(0, iName.length() - 1));
                } else {
                    boolean bl = found = iName.equals(imp) || i.getSimpleName().equals(impSimpleName);
                }
                if (!found) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public void addImportExclusion(String imp) {
        if (this.importExclusions == null) {
            this.importExclusions = new HashSet<String>();
        }
        this.importExclusions.add(imp);
    }

    @Override
    public JavaCodeImport addImport(String imp) {
        return this.addImport(imp, false);
    }

    @Override
    public JavaCodeImport addStaticImport(String imp) {
        return this.addImport(imp, true);
    }

    private JavaCodeImport addImport(String imp, boolean isStatic) {
        JavaCodeImport result = null;
        IJavaCodeImport found = this.findMatchingImport(imp, false);
        if (found == null) {
            result = new JavaCodeImport(imp, this);
            result.setStatic(isStatic);
        } else if (found instanceof JavaCodeImport) {
            result = (JavaCodeImport)found;
        }
        return result;
    }

    private boolean isExcludedImport(String imp) {
        return this.importExclusions != null && this.importExclusions.contains(imp);
    }

    @Override
    @Invisible
    public void registerImport(IJavaCodeImport imp) {
        if (!this.imports.stream().anyMatch(i -> i.isStatic() == imp.isStatic() && i.isWildcard() == imp.isWildcard() && i.getName().equals(imp.getName())) && !this.isExcludedImport(imp.getName())) {
            this.imports.add(imp);
        }
    }

    @Invisible
    public Iterable<IJavaCodeImport> imports() {
        return this.imports;
    }
}

