/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;

public class JavaCodeConstructorCall
extends JavaCodeMethodCall {
    private String generics = null;

    public JavaCodeConstructorCall(IJavaCodeElement parent, String cls, boolean indent, String postfix) {
        this(parent, cls, JavaCodeImportScope.NONE, indent, postfix);
    }

    public JavaCodeConstructorCall(IJavaCodeElement parent, String cls, JavaCodeImportScope scope, boolean indent, String postfix) {
        super(parent, cls, scope, indent, postfix);
    }

    public static JavaCodeConstructorCall create(String cls) {
        return new JavaCodeConstructorCall(null, cls, false, "");
    }

    public static JavaCodeConstructorCall create(String cls, JavaCodeImportScope scope) {
        return new JavaCodeConstructorCall(null, cls, scope, false, "");
    }

    @Override
    protected String validateName(IJavaCodeElement parent, String cls, JavaCodeImportScope scope) {
        String result = cls;
        if (cls.contains(".")) {
            if (JavaCodeImportScope.NONE == scope || parent == null || parent.getArtifact() == null) {
                JavaCodeTypeSpecification type = new JavaCodeTypeSpecification(cls, parent);
                result = type.getOutputType();
            } else {
                result = parent.getArtifact().validateStaticName(cls, scope);
            }
        }
        return result;
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeConstructorCall addArgument(JavaCodeExpression arg) {
        return (JavaCodeConstructorCall)super.addArgument(arg);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeConstructorCall addArgument(JavaCodeParameterSpecification param) {
        return (JavaCodeConstructorCall)super.addArgument(param);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeConstructorCall addArgument(Object arg) {
        return (JavaCodeConstructorCall)super.addArgument(arg);
    }

    @Override
    @OperationMeta(name={"addStringArgument", "stringArg"})
    public JavaCodeConstructorCall addStringArgument(String val) {
        return (JavaCodeConstructorCall)super.addStringArgument(val);
    }

    @Override
    @OperationMeta(name={"addClassArgument", "classArg"})
    public JavaCodeConstructorCall addClassArgument(String cls) {
        return (JavaCodeConstructorCall)super.addClassArgument(cls);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeConstructorCall addArgument(String arg) {
        return (JavaCodeConstructorCall)super.addArgument(arg);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(String methodName, JavaCodeImportScope scope) {
        return super.addArgument(methodName, scope);
    }

    @Override
    public JavaCodeConstructorCall addNew(String cls) {
        return super.addNew(cls);
    }

    public JavaCodeConstructorCall addGenerics(String generics) {
        this.generics = generics;
        return this;
    }

    @Override
    protected void storeBefore(CodeWriter out) {
        out.print("new ");
    }

    @Override
    protected void storeAfterName(CodeWriter out) {
        if (this.generics != null) {
            out.print("<");
            out.print(this.generics);
            out.print(">");
        }
    }
}

