/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeJavadocComment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethod;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibility;

public class JavaCodeEnum
extends JavaCodeClass {
    private List<JavaCodeEnumConstant> constants = new ArrayList<JavaCodeEnumConstant>();

    JavaCodeEnum(String name, IJavaCodeArtifact artifact) {
        super(name, artifact);
        this.setKind(JavaCodeClass.Kind.ENUM);
    }

    JavaCodeEnum(String name, IJavaCodeArtifact artifact, String comment) {
        super(name, artifact, comment);
        this.setKind(JavaCodeClass.Kind.ENUM);
    }

    JavaCodeEnum(String name, JavaCodeClass enclosing) {
        super(name, enclosing);
        this.setKind(JavaCodeClass.Kind.ENUM);
    }

    JavaCodeEnum(String name, JavaCodeClass enclosing, String comment) {
        super(name, enclosing, comment);
        this.setKind(JavaCodeClass.Kind.ENUM);
    }

    @Override
    protected JavaCodeMethod configureConstructor(JavaCodeMethod cons) {
        return cons.setPrivate();
    }

    public JavaCodeEnumConstant addLiteral(String name) {
        return this.addLiteral(name, "");
    }

    public JavaCodeEnumConstant addLiteral(String name, String comment) {
        Optional<JavaCodeEnumConstant> found = this.constants.stream().filter(c -> c.getMethodName().equals(name)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        JavaCodeEnumConstant result = new JavaCodeEnumConstant(name, comment);
        this.constants.add(result);
        return result;
    }

    @Override
    public JavaCodeEnum addExtends(String type) {
        return this;
    }

    @Override
    public JavaCodeEnum addInterface(String type) {
        super.addInterface(type);
        return this;
    }

    @Override
    public JavaCodeEnum setVisibility(String visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    public JavaCodeEnum setVisibility(JavaCodeVisibility visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    public JavaCodeEnum asInterface() {
        return this;
    }

    @Override
    public JavaCodeEnum asAnnotation() {
        return this;
    }

    @Override
    public JavaCodeEnum setPublic() {
        super.setPublic();
        return this;
    }

    @Override
    public JavaCodeEnum setPrivate() {
        super.setPrivate();
        return this;
    }

    @Override
    public JavaCodeEnum setProtected() {
        super.setProtected();
        return this;
    }

    @Override
    public JavaCodeEnum setPackage() {
        super.setPackage();
        return this;
    }

    @Override
    protected void storeAtBlockStart(CodeWriter out) {
        int size = this.constants.size();
        int size1 = size - 1;
        int c = 0;
        while (c < size) {
            JavaCodeEnumConstant constant = this.constants.get(c);
            if (c == 0 || constant.hasComment()) {
                out.println();
            }
            constant.store(out);
            if (c < size1) {
                out.println(",");
            }
            ++c;
        }
        if (this.getElementsCount() > 0) {
            out.println(";");
        }
        out.println();
    }

    public class JavaCodeEnumConstant
    extends JavaCodeMethodCall
    implements IJavaCodeElement {
        private JavaCodeJavadocComment comment;

        public JavaCodeEnumConstant(String methodName, String comment) {
            super(JavaCodeEnum.this, methodName, JavaCodeImportScope.NONE, false, "");
            if (comment != null && comment.length() > 0) {
                this.comment = new JavaCodeJavadocComment(comment, this);
            }
        }

        @Override
        protected void storeBefore(CodeWriter out) {
            if (this.comment != null) {
                this.comment.store(out);
            }
            out.printIndent();
        }

        boolean hasComment() {
            return this.comment != null;
        }

        @Override
        protected void storeArgumentList(CodeWriter out) {
            if (this.getArgumentsCount() > 0) {
                super.storeArgumentList(out);
            }
        }
    }
}

