/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodePostfixExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStatement;

public class JavaCodeExpressionStatement
extends JavaCodeStatement {
    private JavaCodeExpression expression;

    protected JavaCodeExpressionStatement(IJavaCodeElement parent, JavaCodeExpression expression) {
        super(parent);
        this.expression = expression;
        if (this.expression != null) {
            this.expression.setParent(this);
        }
    }

    public static JavaCodeExpressionStatement create(JavaCodeExpression expression) {
        return new JavaCodeExpressionStatement(null, expression);
    }

    static JavaCodeExpressionStatement createPostfixStatement(IJavaCodeElement parent, String variable, boolean increment) {
        return new JavaCodeExpressionStatement(parent, new JavaCodePostfixExpression(null, variable, increment));
    }

    public JavaCodeExpression getExpression() {
        return this.expression;
    }

    @Override
    public void store(CodeWriter out) {
        out.printIndent();
        this.expression.store(out);
        out.println(";");
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        this.expression.setParent(this);
    }

    @Override
    public boolean isEmpty() {
        return this.expression == null || this.expression.isEmpty();
    }

    @Override
    public JavaCodeExpressionStatement replaceVariable(String oldName, String newName) {
        if (this.expression != null) {
            this.expression.replaceVariable(oldName, newName);
        }
        return this;
    }

    @Override
    public JavaCodeExpressionStatement replaceMethod(String oldName, String newName) {
        if (this.expression != null) {
            this.expression.replaceMethod(oldName, newName);
        }
        return this;
    }
}

