/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethod;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class JavaCodeJavadocComment
implements IJavaCodeElement {
    private static final Set<String> HTML_ELEMENTS = Set.of("code", "br", "p", "div", "it", "ul", "ol", "li", "b", "i");
    private static final Set<Character> HTML_ESCAPES = Set.of(Character.valueOf('\u2019'));
    private String comment;
    private IJavaCodeElement attachedTo;
    private List<NameTaggedComment> taggedParts;

    JavaCodeJavadocComment(String comment, IJavaCodeElement attachedTo) {
        String marker;
        int pos;
        this.comment = comment;
        if (comment != null && (pos = comment.lastIndexOf(marker = Tag.RETURN.getTag())) > 0) {
            this.addReturnComment(comment.substring(pos + marker.length()).trim());
            this.comment = comment.substring(0, pos);
        }
        this.attachedTo = attachedTo;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        if (this.comment != null) {
            String[] lines;
            out.printlnwi("/**");
            String[] stringArray = lines = this.comment.split("\\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                out.printlnwi(" * " + JavaCodeJavadocComment.escapeHtml(l.trim()));
                ++n2;
            }
            this.storeTags(out);
            out.printlnwi(" */");
        }
    }

    private void storeTags(CodeWriter out) {
        if (this.taggedParts != null && !this.taggedParts.isEmpty()) {
            this.storeTagsImpl(out);
        }
    }

    private void storeTagsImpl(CodeWriter out) {
        boolean withReturnThrows = false;
        boolean withParam = false;
        if (this.attachedTo instanceof JavaCodeMethod) {
            withReturnThrows = true;
            withParam = true;
        } else if (this.attachedTo instanceof JavaCodeClass) {
            withParam = true;
        }
        if (withReturnThrows || withParam) {
            AtomicInteger before = new AtomicInteger();
            out.printlnwi(" *");
            if (withParam) {
                this.streamByTag(Tag.GENERIC).forEach(t -> t.store(out, before));
                this.streamByTag(Tag.PARAM).forEach(t -> t.store(out, before));
            }
            if (withReturnThrows) {
                this.streamByTag(Tag.RETURN).forEach(t -> t.store(out, before));
                if (this.streamByTag(Tag.THROWS).count() > 0L) {
                    if (before.get() > 0) {
                        out.printlnwi(" *");
                    }
                    this.streamByTag(Tag.THROWS).forEach(t -> t.store(out, null));
                }
            }
        }
    }

    @Override
    public int getElementCount() {
        int result = 0;
        if (this.comment != null) {
            result += 1 + StringUtils.countMatches((String)this.comment, (String)"\\n");
            if (this.taggedParts != null && this.attachedTo instanceof JavaCodeMethod) {
                result += this.taggedParts.size();
            }
        }
        return result;
    }

    private Stream<NameTaggedComment> streamByTag(Tag tag) {
        return this.taggedParts.stream().filter(t -> t.tag == tag);
    }

    private Optional<NameTaggedComment> getTag(Tag tag, String name) {
        return this.taggedParts == null ? Optional.empty() : this.taggedParts.stream().filter(p -> p.tag == tag && p.name.equals(name)).findAny();
    }

    private JavaCodeJavadocComment addTaggedPart(Tag tag, String name, String comment) {
        Optional<NameTaggedComment> t;
        if (this.taggedParts == null) {
            this.taggedParts = new ArrayList<NameTaggedComment>();
        }
        if ((t = this.getTag(tag, name)).isEmpty()) {
            this.taggedParts.add(new NameTaggedComment(tag, name, comment));
        } else {
            t.get().comment = comment;
        }
        return this;
    }

    void setAttachedTo(IJavaCodeElement attachedTo) {
        this.attachedTo = attachedTo;
    }

    public String getComment() {
        return this.comment;
    }

    public JavaCodeJavadocComment setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public JavaCodeJavadocComment setComment(String comment, String returnComment) {
        this.setComment(comment);
        return this.addReturnComment(returnComment);
    }

    public JavaCodeJavadocComment addComment(String comment) {
        if (this.comment == null) {
            this.setComment(comment);
        } else {
            this.comment = String.valueOf(this.comment) + comment;
        }
        return this;
    }

    public JavaCodeJavadocComment addGenericComment(String name, String comment) {
        return this.addTaggedPart(Tag.GENERIC, name, comment);
    }

    public JavaCodeJavadocComment addParameterComment(String name, String comment) {
        return this.addTaggedPart(Tag.PARAM, name, comment);
    }

    public JavaCodeJavadocComment deleteParameterComment(String name) {
        this.taggedParts.removeIf(t -> t.tag == Tag.PARAM && t.name.equals(name));
        return this;
    }

    public JavaCodeJavadocComment addReturnComment(String comment) {
        return this.addTaggedPart(Tag.RETURN, "", comment);
    }

    public JavaCodeJavadocComment addExceptionComment(String type, String comment) {
        return this.addTaggedPart(Tag.THROWS, type, comment);
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        return null;
    }

    @Override
    public IJavaCodeElement getParent() {
        return null;
    }

    @Override
    public void setParent(IJavaCodeElement parent) {
    }

    private static boolean skipHtmlChar(char ch, boolean left) {
        return Character.isWhitespace(ch) || left ? ch == '<' : ch == '>';
    }

    private static boolean isHtmlElement(String text) {
        boolean result = false;
        int left = 0;
        while (left < text.length() && JavaCodeJavadocComment.skipHtmlChar(text.charAt(left), true)) {
            ++left;
        }
        int right = text.length() - 1;
        while (right >= 0 && JavaCodeJavadocComment.skipHtmlChar(text.charAt(right), false)) {
            --right;
        }
        if (left > 0 && right < text.length()) {
            String elt = text.substring(left, right + 1);
            if (elt.startsWith("/")) {
                elt = elt.substring(1);
            } else if (elt.endsWith("/")) {
                elt = elt.substring(0, elt.length() - 1);
            }
            result = HTML_ELEMENTS.contains(elt);
        }
        return result;
    }

    private static String escapeHtmlImpl(String text) {
        return IJavaCodeElement.escape(text, HTML_ESCAPES, StringEscapeUtils::escapeHtml);
    }

    @Invisible
    public static String escapeHtml(String text) {
        CharSequence[] split = text.split("\"");
        int i = 0;
        while (i < split.length) {
            CharSequence tmp = split[i];
            Object tmpRes = "";
            boolean inElement = false;
            int jLastOpen = -1;
            int jLastSplit = 0;
            int j = 0;
            while (j < ((String)tmp).length()) {
                char c = ((String)tmp).charAt(j);
                if (c == '<') {
                    inElement = true;
                    jLastOpen = j;
                } else if (c == '>' && inElement && jLastOpen >= 0) {
                    tmpRes = (String)tmpRes + JavaCodeJavadocComment.escapeHtmlImpl(((String)tmp).substring(jLastSplit, jLastOpen));
                    jLastSplit = j + 1;
                    String elt = ((String)tmp).substring(jLastOpen, jLastSplit);
                    if (!JavaCodeJavadocComment.isHtmlElement(elt)) {
                        elt = JavaCodeJavadocComment.escapeHtmlImpl(elt);
                    }
                    tmpRes = (String)tmpRes + elt;
                    inElement = false;
                }
                ++j;
            }
            split[i] = tmpRes = (String)tmpRes + JavaCodeJavadocComment.escapeHtmlImpl(((String)tmp).substring(jLastSplit, ((String)tmp).length()));
            ++i;
        }
        text = String.join((CharSequence)"\"", split);
        return text;
    }

    @Invisible
    public void copyFrom(JavaCodeJavadocComment comment) {
        if (comment != null) {
            if (comment.comment != null) {
                this.comment = comment.comment;
            }
            if (comment.taggedParts != null) {
                for (NameTaggedComment part : comment.taggedParts) {
                    this.addTaggedPart(part.tag, part.name, part.comment);
                }
            }
        }
    }

    void adjustException(JavaCodeTypeSpecification exc) {
        Optional<NameTaggedComment> t = this.getTag(Tag.THROWS, exc.getFullName());
        if (t.isPresent()) {
            t.get().name = exc.getOutputTypeName();
        }
    }

    private static class NameTaggedComment {
        private Tag tag;
        private String name;
        private String comment;

        private NameTaggedComment(Tag tag, String name, String comment) {
            this.tag = tag;
            this.name = name;
            this.comment = comment;
        }

        public void store(CodeWriter out, AtomicInteger count) {
            Object middle = "";
            if (this.name != null && this.name.length() > 0) {
                middle = " ";
                Object n = this.name;
                if (Tag.GENERIC == this.tag) {
                    if (!((String)n).startsWith("<")) {
                        n = "<" + (String)n;
                    }
                    if (!((String)n).endsWith(">")) {
                        n = (String)n + ">";
                    }
                }
                middle = (String)middle + (String)n;
            }
            out.printlnwi(" * " + this.tag.getTag() + (String)middle + " " + JavaCodeJavadocComment.escapeHtml(this.comment));
            if (count != null) {
                count.incrementAndGet();
            }
        }
    }

    private static enum Tag {
        GENERIC("param"),
        PARAM("param"),
        RETURN("return"),
        THROWS("throws");

        private String tag;

        private Tag(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return "@" + this.tag;
        }
    }
}

