/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;

public class JavaCodeNewArrayExpression
extends JavaCodeParsedExpression {
    private List<JavaCodeExpression> dimensions = new ArrayList<JavaCodeExpression>();
    private JavaCodeTypeSpecification type;

    protected JavaCodeNewArrayExpression(IJavaCodeElement parent, String type) {
        super(parent);
        this.type = new JavaCodeTypeSpecification(type, this);
    }

    public static JavaCodeNewArrayExpression create(String type) {
        return new JavaCodeNewArrayExpression(null, type);
    }

    @OperationMeta(name={"addDimension", "dimension"})
    public JavaCodeNewArrayExpression addDimension(JavaCodeExpression dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        this.type.setParent(this);
    }

    @Override
    public void store(CodeWriter out) {
        out.print("new ");
        this.type.store(out);
        for (JavaCodeExpression d : this.dimensions) {
            out.print("[");
            d.store(out);
            out.print("]");
        }
    }
}

