/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotation;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotationParent;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethod;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;

public class JavaCodeParameterSpecification
extends JavaCodeTypeSpecification
implements JavaCodeAnnotationParent {
    private String name;
    private List<JavaCodeAnnotation> annotations;
    private boolean isFinal;

    protected JavaCodeParameterSpecification(String type, String name, JavaCodeMethod method) {
        super(type, method.getEnclosing());
        this.name = name;
    }

    protected JavaCodeParameterSpecification(JavaCodeTypeSpecification type, String name, JavaCodeMethod method) {
        super(type, method.getEnclosing());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public JavaCodeParameterSpecification setFinal() {
        return this.setFinal(true);
    }

    public JavaCodeParameterSpecification setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    @Override
    @OperationMeta(name={"addAnnotation", "annotate"})
    public JavaCodeAnnotation addAnnotation(String type) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JavaCodeAnnotation>();
        }
        return IJavaCodeElement.add(this.annotations, new JavaCodeAnnotation(new JavaCodeTypeSpecification(type, this.getEnclosing()), this));
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        if (this.annotations != null) {
            for (JavaCodeAnnotation a : this.annotations) {
                a.storeNoLn(out);
            }
        }
        if (this.isFinal) {
            out.print("final ");
        }
        super.store(out);
        out.print(" ");
        out.print(this.name);
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + " " + this.getType() + " " + this.name;
    }
}

