/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import org.apache.commons.lang.StringUtils;

public class JavaCodeText
implements IJavaCodeElement {
    private String text;
    private boolean indent;
    private boolean endWithNewline;

    JavaCodeText(String text, boolean indent, boolean endWithNewline) {
        this.text = text;
        this.indent = indent;
        this.endWithNewline = endWithNewline;
    }

    @Override
    public void store(CodeWriter out) {
        boolean done = false;
        if (this.indent) {
            done = out.printLinesWi(this.text, false, this.endWithNewline);
        }
        if (!done) {
            if (this.indent) {
                out.printIndent();
            }
            out.print(this.text);
            if (this.endWithNewline) {
                out.println();
            }
        }
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        return null;
    }

    @Override
    public IJavaCodeElement getParent() {
        return null;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
    }

    @Override
    public int getElementCount() {
        return StringUtils.countMatches((String)this.text, (String)"\\n") + (this.endWithNewline ? 1 : 0);
    }

    @Override
    public JavaCodeText replaceVariable(String oldName, String newName) {
        if (this.text.equals(oldName)) {
            this.text = newName;
        }
        return this;
    }

    @Override
    public JavaCodeText replaceMethod(String oldName, String newName) {
        if (this.text.equals(oldName)) {
            this.text = newName;
        }
        return this;
    }
}

