/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotation;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotationParent;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeJavadocComment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibility;

public abstract class JavaCodeVisibleElement
extends JavaCodeElement
implements JavaCodeAnnotationParent {
    private boolean isStatic;
    private boolean isFinal;
    private String name;
    private JavaCodeVisibility visibility;
    private List<JavaCodeAnnotation> annotations;
    private JavaCodeJavadocComment comment;

    protected JavaCodeVisibleElement(String name, JavaCodeVisibility visibility, String comment) {
        super(null);
        this.name = this.validateName(name);
        this.visibility = visibility;
        if (comment != null) {
            this.ensureJavadocComment(comment);
        }
    }

    protected String validateName(String name) {
        return name;
    }

    protected void ensureJavadocComment(String comment) {
        if (this.comment == null) {
            this.comment = new JavaCodeJavadocComment(comment, this);
        }
    }

    @Override
    @Invisible
    public String getSortKey() {
        return this.name;
    }

    @Override
    public boolean hasJavadocComment() {
        return this.comment != null;
    }

    public JavaCodeVisibleElement setVisibility(String visibility) {
        this.visibility = JavaCodeVisibility.match(visibility);
        return this;
    }

    public JavaCodeVisibleElement setVisibility(JavaCodeVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public JavaCodeVisibleElement setPublic() {
        this.setVisibility(JavaCodeVisibility.PUBLIC);
        return this;
    }

    public JavaCodeVisibleElement setPublic(boolean isPublic) {
        if (isPublic) {
            this.setPublic();
        }
        return this;
    }

    public JavaCodeVisibleElement setPrivate() {
        this.setVisibility(JavaCodeVisibility.PRIVATE);
        return this;
    }

    public JavaCodeVisibleElement setPrivate(boolean isPrivate) {
        if (isPrivate) {
            this.setPrivate();
        }
        return this;
    }

    public JavaCodeVisibleElement setProtected() {
        this.setVisibility(JavaCodeVisibility.PROTECTED);
        return this;
    }

    public JavaCodeVisibleElement setProtected(boolean isProtected) {
        if (isProtected) {
            this.setProtected();
        }
        return this;
    }

    public JavaCodeVisibleElement setPackage() {
        this.setVisibility(JavaCodeVisibility.PACKAGE);
        return this;
    }

    public JavaCodeVisibleElement setPackage(boolean isPackage) {
        if (isPackage) {
            this.setPackage();
        }
        return this;
    }

    public JavaCodeVisibleElement setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaCodeVisibleElement setStatic() {
        return this.setStatic(true);
    }

    public JavaCodeVisibleElement setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public JavaCodeVisibleElement setFinal() {
        return this.setFinal(true);
    }

    @Override
    @OperationMeta(name={"addAnnotation", "annotate"})
    public JavaCodeAnnotation addAnnotation(String type) {
        return this.addAnnotation(type, null);
    }

    @OperationMeta(name={"addSuppressWarningsAnnotation", "suppressWarnings"})
    public JavaCodeAnnotation addSuppressWarningsAnnotation() {
        return this.addAnnotation(SuppressWarnings.class.getSimpleName());
    }

    @OperationMeta(name={"addAnnotation", "annotate"})
    public JavaCodeAnnotation addAnnotation(String type, String nested) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JavaCodeAnnotation>();
        }
        return IJavaCodeElement.add(this.annotations, new JavaCodeAnnotation(new JavaCodeTypeSpecification(type, this.getClassParent()), nested, this));
    }

    @Invisible
    protected abstract JavaCodeClass getEnclosing();

    @Invisible
    protected JavaCodeClass getClassParent() {
        return this.getEnclosing();
    }

    @Invisible
    JavaCodeVisibility getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isStatic;
    }

    @Invisible
    protected String insertModifier(String text) {
        return text;
    }

    @Invisible
    protected String insertGenerics(String text) {
        return text;
    }

    @Invisible
    protected String getModifier() {
        Object result = this.getVisibility().getPrefix();
        result = this.insertModifier((String)result);
        if (this.isStatic) {
            result = IJavaCodeElement.appendWhitespace((String)result) + "static";
        }
        if (this.isFinal) {
            result = IJavaCodeElement.appendWhitespace((String)result) + "final";
        }
        result = this.insertGenerics((String)result);
        return IJavaCodeElement.appendWhitespace((String)result);
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        if (this.comment != null && this.enableStoreComment()) {
            this.comment.store(out);
        }
        if (this.annotations != null) {
            for (JavaCodeAnnotation a : this.annotations) {
                a.store(out);
            }
        }
    }

    protected boolean enableStoreComment() {
        return true;
    }

    public JavaCodeJavadocComment getJavadocComment() {
        return this.comment;
    }

    void setJavadocComment(JavaCodeJavadocComment comment) {
        if (this.comment == null) {
            this.comment = comment;
            this.comment.setAttachedTo(this);
        } else {
            this.comment.copyFrom(comment);
        }
    }

    @Override
    public int getElementCount() {
        int result = 1;
        if (this.comment != null) {
            result += this.comment.getElementCount();
        }
        if (this.annotations != null) {
            for (JavaCodeAnnotation a : this.annotations) {
                result += a.getElementCount();
            }
        }
        return result;
    }

    protected boolean hasAnnotation(String ... types) {
        boolean result = false;
        if (this.annotations != null) {
            Set tmp = Arrays.stream(types).collect(Collectors.toSet());
            result = this.annotations.stream().anyMatch(a -> tmp.contains(a.getType()));
        }
        return result;
    }
}

