/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;

class ProxyElement
implements IJavaCodeElement {
    private List<IJavaCodeElement> before;
    private IJavaCodeElement delegate;

    ProxyElement() {
    }

    ProxyElement(IJavaCodeElement delegate) {
        this.delegate = delegate;
    }

    void setDelegate(IJavaCodeElement delegate) {
        this.delegate = delegate;
    }

    void addBefore(IJavaCodeElement element) {
        if (this.before == null) {
            this.before = new ArrayList<IJavaCodeElement>();
        }
        this.before.add(element);
    }

    @Override
    @Invisible
    public void addAll(List<IJavaCodeElement> list) {
        if (this.before != null) {
            list.addAll(this.before);
        }
        list.add(this.delegate);
    }

    @Override
    public void store(CodeWriter out) {
        if (this.before != null) {
            for (IJavaCodeElement e : this.before) {
                e.store(out);
            }
        }
        this.delegate.store(out);
    }

    @Override
    public IJavaCodeArtifact getArtifact() {
        return this.delegate.getArtifact();
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.delegate.getParent();
    }

    @Override
    public void setParent(IJavaCodeElement parent) {
        this.delegate.setParent(parent);
    }

    @Override
    @Invisible
    public boolean hasJavadocComment() {
        return this.delegate.hasJavadocComment();
    }

    @Override
    @Invisible
    public boolean isAttribute() {
        return this.delegate.isAttribute();
    }

    @Override
    @Invisible
    public boolean isConstructor() {
        return this.delegate.isConstructor();
    }

    @Override
    @Invisible
    public boolean isMethod() {
        return this.delegate.isMethod();
    }

    @Override
    @Invisible
    public String getSortKey() {
        return this.delegate.getSortKey();
    }

    public static List<IJavaCodeElement> proxy(List<IJavaCodeElement> list) {
        ArrayList<IJavaCodeElement> result = new ArrayList<IJavaCodeElement>();
        ProxyElement last = null;
        for (IJavaCodeElement e : list) {
            if (last == null) {
                last = new ProxyElement();
            }
            if (e.isAttribute() || e.isConstructor() || e.isMethod() || e.isInitializer()) {
                if (last.delegate == null) {
                    last.delegate = e;
                    continue;
                }
                result.add(last);
                last = new ProxyElement(e);
                continue;
            }
            last.addBefore(e);
        }
        if (last != null) {
            result.add(last);
        }
        return result;
    }

    public static List<IJavaCodeElement> unproxy(List<IJavaCodeElement> list) {
        ArrayList<IJavaCodeElement> result = new ArrayList<IJavaCodeElement>();
        for (IJavaCodeElement e : list) {
            e.addAll(result);
        }
        return result;
    }
}

