/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.JavaUtilities;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.CommandLineProgramRegistry;
import net.ssehub.easy.instantiation.core.model.common.ICommandLineProgram;
import net.ssehub.easy.instantiation.core.model.common.StreamGobbler;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.AbstractFileInstantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.maven.Activator;

@Instantiator(value="maven")
public class Maven
extends AbstractFileInstantiator {
    private static final String TMP_FOLDER = "easy-maven367";
    private static final boolean FILTER_SLF4J = true;
    private static final boolean CMD_TEST = true;
    private static final boolean AS_PROCESS = Boolean.valueOf(System.getProperty("easy.maven.asProcess", "true"));
    private static final String MAVEN_HOME = System.getProperty("easy.maven.home", null);
    private static final boolean SKIP = Boolean.valueOf(System.getProperty("easy.maven.skip", "false"));
    private static final String CLASSPATH = System.getProperty("easy.maven.classpath", null);
    private static final String SETTINGS = System.getProperty("easy.maven.settings", System.getenv("MAVEN_SETTINGS_PATH"));
    private static final String REPO_LOCAL = System.getProperty("easy.maven.repo.local", null);
    private static final String CLASSPATH_EXCLUDE = System.getProperty("easy.maven.classpathExclude", null);

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root) throws VilException {
        return Maven.maven(root, null);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, boolean updateSnapshots) throws VilException {
        return Maven.maven(root, null, updateSnapshots);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, Sequence<String> mvnArgs, boolean updateSnapshots) throws VilException {
        return Maven.maven(root, null, mvnArgs, updateSnapshots);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, String buildFilePath) throws VilException {
        return Maven.maven(root, buildFilePath, false);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, String buildFilePath, boolean updateSnapshots) throws VilException {
        return Maven.maven(root, buildFilePath, null, updateSnapshots);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, String buildFilePath, Sequence<String> mvnArgs, boolean updateSnapshots) throws VilException {
        return Maven.build(root, buildFilePath, updateSnapshots, new String[]{"clean", "install"}, mvnArgs);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, Sequence<String> buildtargets) throws VilException {
        return Maven.maven(root, false, buildtargets);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, boolean updateSnapshots, Sequence<String> buildtargets) throws VilException {
        return Maven.maven(root, null, updateSnapshots, buildtargets);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, Sequence<String> mvnArgs, boolean updateSnapshots, Sequence<String> buildtargets) throws VilException {
        return Maven.build(root, null, updateSnapshots, Maven.toTargets(buildtargets), mvnArgs);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, String buildFilePath, Sequence<String> buildtargets) throws VilException {
        return Maven.maven(root, buildFilePath, false, buildtargets);
    }

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> maven(Path root, String buildFilePath, boolean updateSnapshots, Sequence<String> buildtargets) throws VilException {
        return Maven.build(root, buildFilePath, updateSnapshots, Maven.toTargets(buildtargets), null);
    }

    private static String[] toTargets(Sequence<String> buildtargets) {
        int targetsCount = buildtargets.size();
        String[] targets = new String[targetsCount];
        int i = 0;
        while (i < targetsCount) {
            targets[i] = (String)buildtargets.get(i);
            ++i;
        }
        return targets;
    }

    private static void addArguments(List<String> arguments, boolean updateSnapshots, Sequence<String> mvnArgs) {
        String mvnUpdateArg = "-U";
        boolean doUpdate = false;
        if (mvnArgs != null) {
            for (String arg : mvnArgs) {
                arg = arg.trim();
                doUpdate = "-U".equals(arg);
                arguments.add(arg);
            }
        }
        if (!doUpdate && updateSnapshots) {
            arguments.add("-U");
        }
    }

    private static Set<FileArtifact> build(Path root, String buildFilePath, boolean updateSnapshots, String[] targets, Sequence<String> mvnArgs) throws VilException {
        ArrayList result = new ArrayList();
        if (!SKIP) {
            File targetPath = Maven.determineTargetPath((Path)root);
            buildFilePath = buildFilePath != null ? new File(targetPath, buildFilePath).toString() : targetPath.toString();
            long timestamp = PathUtils.normalizedTime();
            int cliResult = -1;
            boolean asProcess = AS_PROCESS;
            if (!AS_PROCESS) {
                ICommandLineProgram prg = CommandLineProgramRegistry.getRegisteredProgram((String)"mvn");
                if (prg != null) {
                    ArrayList<String> arguments = new ArrayList<String>();
                    Maven.addArguments(arguments, updateSnapshots, mvnArgs);
                    String[] stringArray = targets;
                    int n = targets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        arguments.add(t);
                        ++n2;
                    }
                    Maven.splitArgs(System.getenv("MAVEN_ARGS"), arguments);
                    String[] args = new String[arguments.size()];
                    cliResult = prg.prepare().execute(arguments.toArray(args), buildFilePath, System.out, System.out);
                } else {
                    Maven.getLogger().warn("Cannot obtain Maven command line instance. Trying to run Maven as process (fallback).");
                    asProcess = true;
                }
            }
            if (asProcess) {
                try {
                    cliResult = Maven.runAsProcess(buildFilePath, updateSnapshots, targets, mvnArgs);
                }
                catch (IOException | InterruptedException e) {
                    throw new VilException("maven build failed: " + e.getMessage(), 30012);
                }
            }
            if (cliResult != 0) {
                throw new VilException("maven build failed", 30012);
            }
            FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
            FileUtils.scan((File)targetPath.getAbsoluteFile(), (ArtifactModel)root.getArtifactModel(), (long)timestamp, (FileUtils.ScanResult)scanResult, FileArtifact.class);
            scanResult.checkForException();
        }
        return new ListSet(result, FileArtifact.class);
    }

    private static String getClasspath() {
        String result = null;
        ClassLoader loader = Maven.class.getClassLoader();
        Class<?> loaderClass = loader.getClass();
        if (loaderClass.getName().indexOf("AntClassLoader") > 0) {
            Method method = null;
            try {
                method = loaderClass.getMethod("getClasspath", new Class[0]);
                method.setAccessible(true);
                Object tmp = method.invoke((Object)loader, new Object[0]);
                if (tmp != null) {
                    result = tmp.toString();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return result;
    }

    private static String rewriteIfUnbundled(String classpath) {
        int pos;
        if (classpath != null && System.getProperty("eclipse.home.location", null) == null && (pos = classpath.indexOf("maven-embedder-")) < 0) {
            int start = pos = Math.max(0, classpath.indexOf("easy-headless.jar"));
            while (start > 0 && classpath.charAt(start) != File.pathSeparatorChar) {
                --start;
            }
            if (start > 0) {
                ++start;
            }
            while (pos < classpath.length() && classpath.charAt(pos) != File.pathSeparatorChar) {
                ++pos;
            }
            if (start < pos) {
                classpath = classpath.substring(start, pos);
                if (CLASSPATH != null) {
                    classpath = Maven.addToClasspath(classpath, CLASSPATH);
                } else {
                    File mavenHome = MAVEN_HOME == null ? Maven.tryUnpack(classpath) : new File(MAVEN_HOME);
                    classpath = Maven.addFilesToClasspath("", new File(mavenHome, "lib"));
                }
            }
        }
        return classpath;
    }

    private static InputStream getResourceAsStream(String name) {
        InputStream result = Maven.class.getResourceAsStream((String)name);
        if (result == null) {
            File f;
            if (((String)name).startsWith("/")) {
                name = "." + (String)name;
            }
            if ((f = new File((String)name)).exists()) {
                try {
                    result = new FileInputStream((String)name);
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        return result;
    }

    private static void closeQuietly(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static File tryUnpack(String classpath) {
        File result = new File(classpath).getParentFile();
        InputStream list = Maven.getResourceAsStream("/dir.list");
        if (list != null) {
            result = new File(FileUtils.getTempDirectory(), TMP_FOLDER);
            File target = new File(result, "lib");
            target.mkdirs();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (LineNumberReader files = new LineNumberReader(new InputStreamReader(list));){
                    String line;
                    do {
                        File f;
                        if ((line = files.readLine()) == null || (line = line.trim()).length() <= 0 || (f = new File(target, line)).exists()) continue;
                        Maven.copyResourceToFile("/lib/" + line, f, Maven.getSub(line));
                    } while (line != null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Maven.getLogger().warn("Maven: Cannot read lib/dir.list: " + e.getMessage());
            }
            Maven.closeQuietly(list);
        }
        return result;
    }

    private static String getSub(String line) {
        int pos = line.lastIndexOf("/");
        String sub = pos > 0 ? line.substring(0, pos) : null;
        return sub;
    }

    private static void copyResourceToFile(String resource, File target, String sub) {
        InputStream fIn = Maven.getResourceAsStream(resource);
        if (fIn != null) {
            try {
                if (sub != null) {
                    File dir = new File(target, sub);
                    dir.mkdirs();
                    dir.deleteOnExit();
                }
                Files.copy(fIn, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                fIn.close();
                target.deleteOnExit();
            }
            catch (IOException e) {
                Maven.getLogger().error("Maven: Cannot write library " + String.valueOf(target) + ": " + e.getMessage());
            }
        }
    }

    private static String addToClasspath(String classpath, String path) {
        if (((String)classpath).length() > 0) {
            classpath = (String)classpath + File.pathSeparator;
        }
        classpath = (String)classpath + path;
        return classpath;
    }

    private static String addFilesToClasspath(String classpath, File base) {
        File[] mavenLib = base.listFiles();
        if (mavenLib != null) {
            File[] fileArray = mavenLib;
            int n = mavenLib.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".jar")) {
                    classpath = Maven.addToClasspath(classpath, f.getAbsolutePath());
                }
                ++n2;
            }
        }
        return classpath;
    }

    private static int runAsProcess(String buildFilePath, boolean updateSnapshots, String[] targets, Sequence<String> mvnArgs) throws IOException, InterruptedException {
        File jdkFolder;
        ArrayList<String> params = new ArrayList<String>();
        String jdkHome = JavaUtilities.JDK_PATH;
        if (jdkHome == null) {
            jdkHome = System.getProperty("java.home");
        }
        params.add(jdkHome + File.separator + "bin" + File.separator + "java");
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String classpath = Maven.obtainProcessClasspath(contextClassLoader);
        if (classpath.length() > 0) {
            params.add("-cp");
            params.add(classpath);
        }
        Object manipulator = null;
        URL m2Conf = Activator.resolve(contextClassLoader.getResource("conf/m2.conf"));
        if (Activator.isFileProtocol(m2Conf)) {
            File confFile = Environment.toFile((URL)m2Conf);
            File mavenHome = confFile.getParentFile().getParentFile();
            params.add("-Dmaven.home=" + mavenHome.getAbsolutePath());
            params.add("-Dclassworlds.conf=" + confFile.getAbsolutePath());
            params.add("org.codehaus.plexus.classworlds.launcher.Launcher");
            manipulator = new PlexusMessageManipulator();
        } else {
            m2Conf = null;
        }
        params.add("-Dmaven.multiModuleProjectDirectory=false");
        if (m2Conf == null) {
            params.add("org.apache.maven.cli.MavenCli");
            manipulator = new CliMessageManipulator();
        }
        Maven.addArguments(params, updateSnapshots, mvnArgs);
        if (SETTINGS != null) {
            params.add("-s");
            params.add(SETTINGS);
        }
        if (REPO_LOCAL != null) {
            params.add("-Dmaven.repo.local=" + REPO_LOCAL);
        }
        String[] stringArray = targets;
        int n = targets.length;
        int mavenHome = 0;
        while (mavenHome < n) {
            String target = stringArray[mavenHome];
            params.add(target);
            ++mavenHome;
        }
        Maven.splitArgs(System.getenv("MAVEN_ARGS"), params);
        Maven.getLogger().debug("Maven command line: " + String.valueOf(params));
        ProcessBuilder builder = new ProcessBuilder(params);
        if (System.getenv("JAVA_HOME") == null && JavaUtilities.JDK_PATH != null && (jdkFolder = new File(JavaUtilities.JDK_PATH)).exists()) {
            builder.environment().put("JAVA_HOME", JavaUtilities.JDK_PATH);
        }
        builder.directory(new File(buildFilePath));
        Process proc = builder.start();
        StreamGobbler.GobblerConfigurer[] configurers = new StreamGobbler.GobblerConfigurer[]{g -> g.addExcludeFilter(s -> s.startsWith("SLF4J: "))};
        StreamGobbler.gobble((Process)proc, (StreamGobbler.IMsgManipulator)manipulator, (StreamGobbler.GobblerConfigurer[])configurers);
        return proc.waitFor();
    }

    private static void splitArgs(String args, List<String> params) {
        if (args != null && args.length() > 0) {
            boolean inQuote = false;
            int lastPos = 0;
            int i = 0;
            while (i < args.length()) {
                char c = args.charAt(i);
                if (Character.isWhitespace(c) && !inQuote) {
                    params.add(args.substring(lastPos, i).trim());
                    lastPos = i + 1;
                } else if (c == '\"') {
                    inQuote = !inQuote;
                }
                ++i;
            }
            if (lastPos < args.length()) {
                params.add(args.substring(lastPos, args.length()).trim());
            }
        }
    }

    private static EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(Maven.class, "net.ssehub.easy.instantiation.maven");
    }

    private static String obtainProcessClasspath(ClassLoader contextClassLoader) {
        Pattern classpathExclude = null;
        if (CLASSPATH_EXCLUDE != null) {
            try {
                classpathExclude = Pattern.compile(CLASSPATH_EXCLUDE);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        Object classpath = Maven.getClasspath();
        URL[] urls = Activator.getJars();
        if (classpath == null && urls == null && contextClassLoader instanceof URLClassLoader) {
            urls = ((URLClassLoader)contextClassLoader).getURLs();
        }
        if (classpath == null && urls != null) {
            classpath = "";
            URL[] uRLArray = urls;
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL u = uRLArray[n2];
                if (classpathExclude == null || !classpathExclude.matcher(u.toString()).matches()) {
                    File f = Environment.toFile((URL)u);
                    if (((String)classpath).length() > 0) {
                        classpath = (String)classpath + File.pathSeparator;
                    }
                    classpath = (String)classpath + f.getAbsolutePath();
                }
                ++n2;
            }
        }
        if (classpath == null) {
            classpath = System.getProperty("java.class.path");
        }
        classpath = Maven.rewriteIfUnbundled((String)classpath);
        return classpath;
    }

    private static class CliMessageManipulator
    implements StreamGobbler.IMsgManipulator {
        private CliMessageManipulator() {
        }

        public String manipulate(String message) {
            int pos = message.indexOf(" - ");
            if (pos > 0 && pos + 2 < message.length()) {
                message = message.substring(pos + 2);
            }
            return message;
        }
    }

    private static class PlexusMessageManipulator
    implements StreamGobbler.IMsgManipulator {
        private PlexusMessageManipulator() {
        }

        public String manipulate(String message) {
            int pos;
            if (message.startsWith("[") && (pos = message.indexOf("] ")) > 0 && pos + 2 < message.length()) {
                message = message.substring(pos + 2);
            }
            return message;
        }
    }
}

