/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.lxc.instantiators;

import java.io.File;
import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.lxc.instantiators.AbstractLxcInstantiator;

@Instantiator(value="lxcSaveImage")
public class LxcSaveImage
extends AbstractLxcInstantiator {
    public static Set<FileArtifact> lxcSaveImage(String imageName, Path target, String fileName) throws VilException {
        File targetPath;
        long timestamp;
        block3: {
            timestamp = PathUtils.normalizedTime();
            targetPath = LxcSaveImage.determineTargetPath((Path)target);
            String imageNameSub = imageName.substring(imageName.lastIndexOf(":") + 1);
            String destinationPath = targetPath.getAbsolutePath().toString();
            String exportImage = "lxc image export ";
            System.out.println(destinationPath);
            boolean imageExists = false;
            try {
                imageExists = LxcSaveImage.createClient().loadImageMap().containsKey(imageNameSub);
                if (!imageExists) {
                    throw new VilException("No image found", 50502);
                }
                LxcSaveImage.createCmdClient().executeLinuxCmd(exportImage + " " + imageName + " " + destinationPath + "/" + fileName);
            }
            catch (Throwable e) {
                if (!FAIL_ON_ERROR) break block3;
                throw new VilException(e, 50502);
            }
        }
        ArrayList result = new ArrayList();
        FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
        FileUtils.scan((File)targetPath.getAbsoluteFile(), (ArtifactModel)target.getArtifactModel(), (long)timestamp, (FileUtils.ScanResult)scanResult, FileArtifact.class);
        scanResult.checkForException();
        return new ListSet(result, FileArtifact.class);
    }
}

