/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.docker.instantiators;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.docker.instantiators.AbstractDockerInstantiator;

@Instantiator(value="dockerSaveImage")
public class DockerSaveImage
extends AbstractDockerInstantiator {
    public static Set<FileArtifact> dockerSaveImage(String imageName, Path target) throws VilException {
        ArrayList<FileArtifact> result = new ArrayList<FileArtifact>();
        if (DockerSaveImage.skip()) {
            result.add(new FileArtifact());
        } else {
            File targetPath;
            long timestamp;
            block5: {
                timestamp = PathUtils.normalizedTime();
                targetPath = DockerSaveImage.determineTargetPath((Path)target);
                try {
                    InputStream in = DockerSaveImage.createClient().saveImageCmd(imageName).exec();
                    if (in == null) {
                        throw new VilException("No image found, stream=null", 50502);
                    }
                    Files.copy(in, targetPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    if (!FAIL_ON_ERROR) break block5;
                    throw new VilException((Throwable)e, 50502);
                }
            }
            FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
            FileUtils.scan((File)targetPath.getAbsoluteFile(), (ArtifactModel)target.getArtifactModel(), (long)timestamp, (FileUtils.ScanResult)scanResult, FileArtifact.class);
            scanResult.checkForException();
        }
        return new ListSet(result, FileArtifact.class);
    }
}

