/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.ant;

import de.uni_hildesheim.sse.easy.loader.Generator;
import de.uni_hildesheim.sse.easy.loader.IExclusionSelector;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class AntGenerator
extends Task {
    private static final boolean DEBUG = false;
    private Vector<BaseFeature> base = new Vector();
    private Vector<AddFeature> addF = new Vector();
    private boolean forced = true;
    private String pluginPath = ".";
    private String target = "newGenerator";
    private String eclipsePath = "plugins/eclipse";
    private String baseDir = ".";
    private String libsPath = ".";
    private IExclusionSelector exclusionSelector = null;
    private String classesPath = "bin";

    public BaseFeature createBaseFeature() {
        BaseFeature base = new BaseFeature();
        this.base.add(base);
        return base;
    }

    public AddFeature createAddFeature() {
        AddFeature addF = new AddFeature();
        this.addF.add(addF);
        return addF;
    }

    public void setLibsPath(String libs) {
        if (libs != null) {
            this.libsPath = libs;
        }
    }

    public void setTarget(String target) {
        if (target != null) {
            this.target = target;
        }
    }

    public void setExcludes(String excludes) {
        this.exclusionSelector = new AntPathExclusionSelector(excludes);
    }

    public void setEclipsePath(String eclipsePath) {
        if (eclipsePath != null) {
            this.eclipsePath = eclipsePath;
            System.out.println("Eclipse Path is: " + eclipsePath);
        }
    }

    public void setBaseDir(String baseDir) {
        if (baseDir != null) {
            this.baseDir = baseDir;
        }
    }

    public void setForced(String forced) {
        if (forced != null && ((forced = forced.toLowerCase()).equals("0") || forced.equals("no") || forced.equals("false"))) {
            this.forced = false;
        }
    }

    public void setPluginPath(String pluginPath) {
        if (pluginPath != null) {
            this.pluginPath = pluginPath;
        }
    }

    public void setClassesPath(String classesPath) {
        if (this.pluginPath != null) {
            this.classesPath = classesPath;
        }
    }

    public void execute() {
        ArrayList<File> baseList = new ArrayList<File>();
        ArrayList<File> addList = new ArrayList<File>();
        int i = 0;
        while (i < this.base.size()) {
            baseList.add(this.base.get(i).getFile());
            ++i;
        }
        i = 0;
        while (i < this.addF.size()) {
            addList.add(this.addF.get(i).getFile());
            ++i;
        }
        Generator.setExclusionSelector(this.exclusionSelector);
        Generator.autoGenerate(baseList, addList, this.forced, this.pluginPath, this.eclipsePath, this.target, this.baseDir, this.classesPath, this.libsPath);
    }

    public class AddFeature {
        private String path;
        private File file = null;

        public void setPath(String path) {
            this.path = path;
        }

        public File getFile() {
            if (this.path != null && this.file == null) {
                this.file = new File(this.path);
            }
            return this.file;
        }
    }

    private static class AntPathExclusionSelector
    implements IExclusionSelector {
        private List<String> patterns = new ArrayList<String>();

        private AntPathExclusionSelector(String excludes) {
            StringTokenizer tok = new StringTokenizer(excludes, ", ", false);
            while (tok.hasMoreTokens()) {
                this.patterns.add(tok.nextToken());
            }
        }

        @Override
        public boolean isExcluded(String name) {
            boolean excluded = false;
            int p = 0;
            while (!excluded && p < this.patterns.size()) {
                excluded = SelectorUtils.match((String)this.patterns.get(p), (String)name);
                ++p;
            }
            return excluded;
        }
    }

    public class BaseFeature {
        private String path;
        private File file = null;

        public void setPath(String path) {
            this.path = path;
        }

        public File getFile() {
            if (this.path != null && this.file == null) {
                this.file = new File(this.path);
            }
            return this.file;
        }
    }
}

