/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.AbstractStartupInfoLoader;
import de.uni_hildesheim.sse.easy.loader.InitType;
import de.uni_hildesheim.sse.easy.loader.StartupInfo;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ListLoader
extends AbstractStartupInfoLoader {
    public static final String EASY_STARTUP_FILE_NAME = ".easyStartup";

    public ListLoader() throws IOException {
        this((File)null);
    }

    public ListLoader(ClassLoader loader) throws IOException {
        this(null, loader);
    }

    public ListLoader(File listFile) throws IOException {
        this(listFile, ListLoader.class.getClassLoader());
    }

    public ListLoader(File listFile, ClassLoader loader) throws IOException {
        super(ListLoader.load(ListLoader.getStream(listFile, loader)));
    }

    public ListLoader(InputStream is) throws IOException {
        super(ListLoader.load(is));
    }

    public ListLoader(Reader reader) throws IOException {
        super(ListLoader.load(reader));
    }

    private static List<StartupInfo> load(InputStream is) throws IOException {
        return ListLoader.load(new InputStreamReader(is));
    }

    private static InputStream getStream(File listFile, ClassLoader loader) throws IOException {
        InputStream is = listFile == null ? loader.getResourceAsStream(EASY_STARTUP_FILE_NAME) : new FileInputStream(listFile);
        return is;
    }

    private static List<StartupInfo> load(Reader reader) throws IOException {
        ArrayList<StartupInfo> result = new ArrayList<StartupInfo>();
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = null;
        do {
            if ((line = lnr.readLine()) == null) continue;
            ListLoader.processLine(line, result);
        } while (line != null);
        Utils.closeQuietly(reader);
        return result;
    }

    private static void processLine(String line, List<StartupInfo> startupSequence) {
        int pos = line.indexOf(58);
        if (pos > 0 && line.length() > pos) {
            String marker = line.substring(0, pos).trim();
            String className = line.substring(pos + 1).trim();
            InitType type = InitType.valueOf(marker);
            if (type != null) {
                startupSequence.add(new StartupInfo(type, className));
            }
        }
    }
}

