/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.AbstractStartupInfoLoader;
import de.uni_hildesheim.sse.easy.loader.InitType;
import de.uni_hildesheim.sse.easy.loader.StartupInfo;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestLoader
extends AbstractStartupInfoLoader {
    public static final String MF_PATH = "META-INF/MANIFEST.MF";

    public ManifestLoader() throws IOException {
        this(false);
    }

    public ManifestLoader(ClassLoader loader) throws IOException {
        this(false, loader);
    }

    public ManifestLoader(boolean verbose) throws IOException {
        this(verbose, null);
    }

    public ManifestLoader(boolean verbose, ClassLoader loader) throws IOException {
        super(ManifestLoader.loadManifests(verbose, loader));
        this.setVerbose(verbose);
        super.setLoader(loader);
    }

    @Override
    public void setLoader(ClassLoader loader) {
        super.setLoader(loader);
        if (loader != null) {
            try {
                this.setStartupSequence(ManifestLoader.loadManifests(this.isVerbose(), loader));
            }
            catch (IOException e) {
                System.err.println("Error reading manifests: " + e.getMessage());
            }
        }
    }

    public static List<StartupInfo> loadManifests(boolean verbose, ClassLoader loader) throws IOException {
        try {
            ArrayList<StartupInfo> reasoning = new ArrayList<StartupInfo>();
            ArrayList<StartupInfo> ivml = new ArrayList<StartupInfo>();
            ArrayList<StartupInfo> instantiationCore = new ArrayList<StartupInfo>();
            ArrayList<StartupInfo> vilVtl = new ArrayList<StartupInfo>();
            ArrayList<StartupInfo> instantiators = new ArrayList<StartupInfo>();
            ArrayList<StartupInfo> rest = new ArrayList<StartupInfo>();
            ClassLoader resourceLoader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
            Enumeration<URL> resources = resourceLoader.getResources(MF_PATH);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            while (resources.hasMoreElements()) {
                StartupInfo info;
                URL url = resources.nextElement();
                if (verbose) {
                    Log.info("Reading manifest: " + String.valueOf(url));
                }
                if ((info = ManifestLoader.loadManifest(url, builder, verbose)) == null) continue;
                String cls = info.getClassName();
                if (cls.contains("reasoning")) {
                    reasoning.add(info);
                    continue;
                }
                if (cls.contains("Ivml")) {
                    ivml.add(info);
                    continue;
                }
                if (cls.contains("instantiation.core")) {
                    instantiationCore.add(info);
                    continue;
                }
                if (cls.contains("Vtl") || cls.contains("Vil")) {
                    vilVtl.add(info);
                    continue;
                }
                if (cls.contains("instantiation")) {
                    instantiators.add(info);
                    continue;
                }
                if (cls.startsWith("org.")) continue;
                rest.add(info);
            }
            ArrayList<StartupInfo> result = new ArrayList<StartupInfo>();
            result.addAll(reasoning);
            result.addAll(instantiationCore);
            result.addAll(ivml);
            result.addAll(vilVtl);
            result.addAll(instantiators);
            result.addAll(rest);
            return result;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static StartupInfo loadManifest(URL url, DocumentBuilder builder, boolean verbose) throws IOException {
        StartupInfo result = null;
        Manifest mf = new Manifest(url.openStream());
        Attributes attr = mf.getMainAttributes();
        String serviceComponent = attr.getValue("Service-Component");
        if (serviceComponent != null) {
            if (verbose) {
                Log.info(" - Found service component: " + serviceComponent);
            }
            StringTokenizer components = new StringTokenizer(serviceComponent, ",");
            while (components.hasMoreTokens()) {
                Object component = components.nextToken().trim();
                Object tmp = url.toString();
                tmp = ((String)tmp).substring(0, ((String)tmp).length() - MF_PATH.length());
                while (((String)tmp).endsWith("/")) {
                    tmp = ((String)tmp).substring(0, ((String)tmp).length() - 1);
                }
                if (!((String)component).startsWith("/")) {
                    component = "/" + (String)component;
                }
                tmp = (String)tmp + (String)component;
                URL scUrl = new URL((String)tmp);
                if (verbose) {
                    Log.info(" - Reading service descriptor: " + (String)tmp);
                }
                try {
                    Document doc = builder.parse(scUrl.openStream());
                    NodeList implList = doc.getElementsByTagName("implementation");
                    int i = 0;
                    while (i < implList.getLength()) {
                        Node implNode = implList.item(i);
                        Node clsNode = implNode.getAttributes().getNamedItem("class");
                        if (clsNode != null) {
                            if (verbose) {
                                Log.info(" - Found service implementation: " + clsNode.getNodeValue());
                            }
                            result = new StartupInfo(InitType.DS, clsNode.getNodeValue());
                        }
                        ++i;
                    }
                }
                catch (IOException | SAXException e) {
                    System.err.println("Cannot read " + (String)tmp + ": " + e.getMessage() + " Ignoring.");
                }
            }
        } else {
            String activator = attr.getValue("Bundle-Activator");
            if (activator != null) {
                if (verbose) {
                    Log.info(" - Found bundle activator: " + activator);
                }
                result = new StartupInfo(InitType.ACTIVATOR, activator);
            }
        }
        return result;
    }
}

