/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import de.uni_hildesheim.sse.easy.loader.framework.BundleException;
import de.uni_hildesheim.sse.easy.loader.framework.BundleRegistry;
import de.uni_hildesheim.sse.easy.loader.framework.EasyDependency;
import de.uni_hildesheim.sse.easy.loader.framework.LoaderLog;
import de.uni_hildesheim.sse.easy.loader.framework.Options;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import de.uni_hildesheim.sse.easy.loader.framework.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BundleInfo {
    private static final DocumentBuilderFactory XML_FACTORY = DocumentBuilderFactory.newInstance();
    private File resolved;
    private String name;
    private boolean singleton;
    private Version version;
    private String activator;
    private String activationPolicy;
    private String dsSpec;
    private String[] dsClasses;
    private BundleInfo[] requiredBundles;
    private String[] importPackages;
    private String[] exportPackages;
    private Object tag;
    private String sampleClass;
    private ClassLoader loader;
    private boolean doBundleClassPath;
    private String[] classpath;
    private String[] origClasspath;

    private BundleInfo(File file, Manifest manifest) throws BundleException {
        this.resolve(file, manifest);
        BundleRegistry.getInstance().add(this);
    }

    private BundleInfo(String name, EasyDependency versionRestriction) throws BundleException {
        if (name == null || name.length() == 0) {
            throw new BundleException("no symbolic name given");
        }
        this.name = name;
        this.resolved = null;
        BundleRegistry.getInstance().add(this);
    }

    public static BundleInfo createInstance(String name, EasyDependency versionSpec) throws BundleException {
        BundleInfo info = null;
        if (!BundleRegistry.getInstance().ignoreBundle(name) && (info = BundleRegistry.getInstance().get(name, versionSpec)) == null) {
            info = new BundleInfo(name, versionSpec);
        }
        return info;
    }

    public static BundleInfo createInstance(File file) throws BundleException {
        BundleInfo info = null;
        JarFile jarFile = null;
        InputStream is = null;
        EasyDependency dependancy = new EasyDependency();
        try {
            jarFile = new JarFile(file);
            Manifest mf = jarFile.getManifest();
            Attributes attributes = BundleInfo.getAttributes(mf);
            String name = BundleInfo.parseSymbolicName(attributes);
            if (!BundleRegistry.getInstance().ignoreBundle(name)) {
                ZipEntry entry;
                Version version = BundleInfo.parseVersion(attributes);
                dependancy.setBundleVersionMin(version);
                info = BundleRegistry.getInstance().get(name, dependancy);
                info = info == null ? new BundleInfo(file, mf) : new BundleInfo(file, mf);
                if (info.getDsSpec() != null && (entry = jarFile.getEntry(info.getDsSpec())) != null) {
                    is = jarFile.getInputStream(entry);
                    info.parseDsSpec(is);
                    is.close();
                    is = null;
                }
                if (info.getSampleClass() == null) {
                    info.setSampleClass(BundleInfo.getSampleClass(jarFile));
                }
            }
            jarFile.close();
        }
        catch (IOException e) {
            Utils.closeQuietly(is);
            Utils.closeQuietly(jarFile);
            throw new BundleException(e.getMessage());
        }
        catch (BundleException e) {
            Utils.closeQuietly(is);
            Utils.closeQuietly(jarFile);
            throw e;
        }
        return info;
    }

    public static String getSampleClass(JarFile jarFile) {
        String result = null;
        if (Options.considerLoadedClasses()) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (result == null && entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.length() <= ".class".length() || !name.endsWith(".class") || name.endsWith("package-info.class")) continue;
                result = name.substring(0, name.length() - ".class".length()).replace('/', '.');
            }
        }
        return result;
    }

    static Attributes getAttributes(Manifest manifest) {
        return manifest.getMainAttributes();
    }

    static Version parseVersion(Attributes attributes) throws BundleException {
        String tmp = attributes.getValue("Bundle-Version");
        Version result = tmp == null ? new Version("0") : new Version(tmp);
        return result;
    }

    private static String[] parsePackageList(Attributes attributes, String key) {
        String[] result = null;
        String tmp = attributes.getValue(key);
        if (tmp != null && (result = tmp.split("\\s*,\\s*")) != null && result.length == 0) {
            result = null;
        }
        return result;
    }

    private static String[] parseClasspath(Attributes attributes) {
        String[] result;
        ArrayList<String> res = new ArrayList<String>();
        String tmp = attributes.getValue("Bundle-ClassPath");
        if (tmp != null) {
            String[] tmpCp = tmp.split("\\s*,\\s*");
            int t = 0;
            while (t < tmpCp.length) {
                if (!tmpCp[t].equals(".") && !tmpCp[t].equals("lib/")) {
                    res.add(tmpCp[t]);
                }
                ++t;
            }
        }
        if (res.isEmpty()) {
            result = null;
        } else {
            result = new String[res.size()];
            res.toArray(result);
        }
        return result;
    }

    private List<String> splitBundleList(String text) {
        ArrayList<String> tmp = new ArrayList<String>();
        int pos = 0;
        int lastCut = 0;
        boolean inQuote = false;
        while (pos < text.length()) {
            char c = text.charAt(pos);
            if ('\"' == c) {
                inQuote = !inQuote;
            } else if (',' == c && !inQuote) {
                tmp.add(text.substring(lastCut, pos));
                lastCut = pos + 1;
            }
            ++pos;
        }
        if (lastCut != text.length()) {
            tmp.add(text.substring(lastCut, text.length()));
        }
        return tmp;
    }

    private BundleInfo[] parseBundleList(Attributes attributes, String key) throws BundleException {
        List<String> bundles;
        BundleInfo[] result = null;
        String tmp = attributes.getValue(key);
        if (tmp != null && (bundles = this.splitBundleList(tmp)) != null && bundles.size() > 0) {
            ArrayList<BundleInfo> tmpResult = new ArrayList<BundleInfo>();
            int i = 0;
            while (i < bundles.size()) {
                BundleInfo info;
                String bundle = bundles.get(i);
                String name = null;
                EasyDependency versionSpec = new EasyDependency("bundle-symbolic-name:=" + bundle);
                int pos = bundle.indexOf(";");
                name = pos > 0 ? bundle.substring(0, pos) : bundle;
                boolean optional = false;
                if (versionSpec != null) {
                    boolean bl = optional = !versionSpec.getMandatory();
                }
                if (!optional && (info = BundleInfo.createInstance(name, versionSpec)) != null) {
                    tmpResult.add(info);
                }
                ++i;
            }
            result = new BundleInfo[tmpResult.size()];
            tmpResult.toArray(result);
        }
        return result;
    }

    static String parseSymbolicName(Attributes attributes) throws BundleException {
        String tmp = attributes.getValue("Bundle-SymbolicName");
        if (tmp == null) {
            throw new BundleException("no symbolic name given");
        }
        int pos = tmp.indexOf(";");
        if (pos > 0) {
            tmp = tmp.substring(0, pos);
        }
        return tmp;
    }

    private static boolean parseSingleton(Attributes attributes) throws BundleException {
        String tmp = attributes.getValue("Bundle-SymbolicName");
        if (tmp == null) {
            throw new BundleException("no symbolic name given");
        }
        String symName = BundleInfo.parseSymbolicName(attributes);
        boolean singleton = false;
        if (tmp.length() > symName.length() + 1) {
            singleton = tmp.substring(symName.length() + 1).matches(".*singleton\\s*:=\\s*(\"?)true(\"?).*");
        }
        return singleton;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getActivatorClassName() {
        return this.activator;
    }

    public String getActivationPolicy() {
        return this.activationPolicy;
    }

    public String getDsSpec() {
        return this.dsSpec;
    }

    public File getResolvedJar() {
        return this.resolved;
    }

    public void tag(Object tag) {
        this.tag = tag;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setClassloader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassloader() {
        return this.loader;
    }

    public void resolve(File file, Manifest manifest) throws BundleException {
        if (this.resolved == null) {
            this.resolved = file;
            Attributes attributes = BundleInfo.getAttributes(manifest);
            this.name = BundleInfo.parseSymbolicName(attributes);
            this.singleton = BundleInfo.parseSingleton(attributes);
            this.version = BundleInfo.parseVersion(attributes);
            this.activator = attributes.getValue("Bundle-Activator");
            this.activationPolicy = attributes.getValue("Bundle-ActivationPolicy");
            this.importPackages = BundleInfo.parsePackageList(attributes, "Import-Package");
            this.exportPackages = BundleInfo.parsePackageList(attributes, "Export-Package");
            this.requiredBundles = this.parseBundleList(attributes, "Require-Bundle");
            this.dsSpec = attributes.getValue("Service-Component");
            this.doBundleClassPath = BundleInfo.parseDoBundleClassPath(attributes);
            this.origClasspath = BundleInfo.parseClasspath(attributes);
            this.classpath = !this.doBundleClassPath ? null : this.origClasspath;
        }
    }

    public Set<String> excludeFromJar() {
        HashSet<String> result = null;
        if (!this.doBundleClassPath && this.origClasspath != null) {
            result = new HashSet<String>();
            String[] stringArray = this.origClasspath;
            int n = this.origClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                result.add(path);
                ++n2;
            }
        }
        return result;
    }

    private static boolean parseDoBundleClassPath(Attributes attributes) {
        String tmp = attributes.getValue("EASyLoader-BundleClassPath");
        return tmp == null || Boolean.valueOf(tmp) != false;
    }

    public int getRequiredBundlesCount() {
        return this.requiredBundles == null ? 0 : this.requiredBundles.length;
    }

    public BundleInfo getRequiredBundle(int index) {
        if (this.requiredBundles == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.requiredBundles[index];
    }

    public int getDsClassesCount() {
        return this.dsClasses == null ? 0 : this.dsClasses.length;
    }

    public String getDsClass(int index) {
        if (this.dsClasses == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.dsClasses[index];
    }

    public int getClasspathEntryCount() {
        return this.classpath == null ? 0 : this.classpath.length;
    }

    public String getClasspathEntry(int index) {
        if (this.classpath == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.classpath[index];
    }

    public String[] getDsClasses() {
        return this.dsClasses == null ? null : (String[])this.dsClasses.clone();
    }

    void parseDsSpec(InputStream is) throws IOException {
        ArrayList<String> tmp = new ArrayList<String>();
        try {
            DocumentBuilder builder = XML_FACTORY.newDocumentBuilder();
            Document doc = builder.parse(is);
            NodeList nodes = doc.getElementsByTagName("implementation");
            int n = 0;
            while (n < nodes.getLength()) {
                String value;
                Node node = nodes.item(n);
                Node className = node.getAttributes().getNamedItem("class");
                if (className != null && (value = className.getNodeValue()) != null) {
                    tmp.add(value);
                }
                ++n;
            }
        }
        catch (ParserConfigurationException e) {
            LoaderLog.writeLn(e.getMessage());
            throw new IOException(e);
        }
        catch (SAXException e) {
            LoaderLog.writeLn(e.getMessage());
            throw new IOException(e);
        }
        if (!tmp.isEmpty()) {
            this.dsClasses = new String[tmp.size()];
            tmp.toArray(this.dsClasses);
        }
    }

    public List<String> analyzeForCyclicDependencies() {
        ArrayList<String> messages = new ArrayList<String>();
        HashSet<BundleInfo> known = new HashSet<BundleInfo>();
        this.analyzeForCyclicDependencies(known, messages, "");
        return messages;
    }

    private void analyzeForCyclicDependencies(Set<BundleInfo> known, List<String> messages, String path) {
        if (((String)path).length() > 0) {
            path = (String)path + " -> ";
        }
        path = (String)path + this.toString();
        if (known.contains(this)) {
            messages.add((String)path);
        } else {
            known.add(this);
            if (this.requiredBundles != null) {
                BundleInfo[] bundleInfoArray = this.requiredBundles;
                int n = this.requiredBundles.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleInfo info = bundleInfoArray[n2];
                    info.analyzeForCyclicDependencies(known, messages, (String)path);
                    ++n2;
                }
            }
            known.remove(this);
        }
    }

    public String getSampleClass() {
        return this.sampleClass;
    }

    private void setSampleClass(String sampleClass) {
        this.sampleClass = sampleClass;
    }

    public String toString() {
        Object result = this.getName();
        if (this.version != null) {
            result = (String)result + " " + String.valueOf(this.version);
        }
        return result;
    }
}

