/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.EasyDependency;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BundleRegistry {
    private static final Set<String> IGNORE = new HashSet<String>();
    private static BundleRegistry instance = new BundleRegistry();
    private boolean emitIgoredWarnings = true;
    private final Map<String, List<BundleInfo>> bundles = new HashMap<String, List<BundleInfo>>();
    private BundleRegistry parent;

    private BundleRegistry() {
    }

    public BundleRegistry(BundleRegistry parent) {
        this.parent = parent;
    }

    public static void addGlobalIgnore(String name) {
        if (name != null) {
            IGNORE.add(name);
        }
    }

    public static BundleRegistry getInstance() {
        return instance;
    }

    public static void setInstance(BundleRegistry registry) {
        if (registry != null) {
            instance = registry;
        }
    }

    boolean ignoreBundle(String name) {
        return IGNORE.contains(name);
    }

    public void setEmitIgoredWarnings(boolean emit) {
        this.emitIgoredWarnings = emit;
    }

    void add(BundleInfo info) {
        String name = info.getName();
        List<BundleInfo> sameName = this.getInfoSafe(name);
        if (sameName.isEmpty()) {
            sameName.add(info);
        } else {
            if (this.emitIgoredWarnings) {
                Log.warn("Multiple bundles with symbolic name " + name + " being registered. (" + BundleRegistry.collectVersions(sameName) + ") This is currently not supported and version " + String.valueOf(info.getVersion()) + " is ignored.");
            }
            sameName.add(info);
        }
    }

    private static String collectVersions(List<BundleInfo> infos) {
        StringBuilder tmp = new StringBuilder();
        for (BundleInfo info : infos) {
            Version version = info.getVersion();
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            if (version == null) {
                tmp.append("?");
                continue;
            }
            tmp.append(version);
        }
        return tmp.toString();
    }

    private List<BundleInfo> getInfoSafe(String name) {
        List<BundleInfo> sameName = this.bundles.get(name);
        if (sameName == null) {
            sameName = new ArrayList<BundleInfo>();
            this.bundles.put(name, sameName);
        }
        return sameName;
    }

    public BundleInfo get(String name, EasyDependency versionSpec) {
        BundleInfo result;
        List<BundleInfo> sameName = this.bundles.get(name);
        if (sameName == null || sameName.isEmpty()) {
            if (this.parent != null) {
                result = this.parent.get(name, versionSpec);
                if (result != null) {
                    this.add(result);
                }
            } else {
                result = null;
            }
        } else {
            result = null;
            int i = 0;
            while (i < sameName.size()) {
                if (sameName.get(i).getVersion() != null && sameName.get(i).getVersion().isInRange(versionSpec.getBundleVersionMin(), versionSpec.getBundleVersionMax()) && (result == null || result.getVersion().compareTo(sameName.get(i).getVersion()) == -1)) {
                    result = sameName.get(i);
                }
                ++i;
            }
        }
        return result;
    }

    public List<BundleInfo> getAllBundles() {
        ArrayList<BundleInfo> roots = new ArrayList<BundleInfo>();
        for (List<BundleInfo> sameName : this.bundles.values()) {
            for (BundleInfo info : sameName) {
                roots.add(info);
            }
        }
        return roots;
    }

    public List<BundleInfo> getRootBundles() {
        ArrayList<BundleInfo> roots = new ArrayList<BundleInfo>();
        HashSet<BundleInfo> unused = new HashSet<BundleInfo>();
        for (BundleInfo info : this.getAllBundles()) {
            unused.add(info);
        }
        for (BundleInfo info : this.getAllBundles()) {
            int p = 0;
            while (p < info.getRequiredBundlesCount()) {
                unused.remove(info.getRequiredBundle(p));
                ++p;
            }
        }
        for (BundleInfo info : unused) {
            roots.add(info);
        }
        return roots;
    }

    public List<BundleInfo> getUnresolvedBundles() {
        ArrayList<BundleInfo> roots = new ArrayList<BundleInfo>();
        for (BundleInfo info : this.getAllBundles()) {
            if (info.getResolvedJar() != null) continue;
            roots.add(info);
        }
        return roots;
    }
}

