/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import de.uni_hildesheim.sse.easy.loader.framework.BundleException;
import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.FakeBundleContext;
import de.uni_hildesheim.sse.easy.loader.framework.FakeComponentContext;
import de.uni_hildesheim.sse.easy.loader.framework.IBundleFilter;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.Version;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Utils {
    public static final String CLASS_SUFFIX = ".class";
    private static final String TEXT_CANNOT_INITIALIZE = "Cannot initialize";
    private static File temp;

    private Utils() {
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final URL[] toArray(List<URL> urls) {
        URL[] result = new URL[urls.size()];
        urls.toArray(result);
        return result;
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        int count = 0;
        do {
            if ((count = is.read(buffer)) <= 0) continue;
            os.write(buffer, 0, count);
        } while (count > 0);
    }

    public static List<String> analyzeForCyclicDependencies(List<BundleInfo> infos) {
        ArrayList<String> messages = new ArrayList<String>();
        for (BundleInfo info : infos) {
            messages.addAll(info.analyzeForCyclicDependencies());
        }
        return messages;
    }

    public static List<BundleInfo> sortByContainment(List<BundleInfo> infos) {
        BundleInfo info;
        int i;
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        HashMap<String, BundleInfo> mapping = new HashMap<String, BundleInfo>();
        int i2 = infos.size() - 1;
        while (i2 >= 0) {
            BundleInfo info2 = infos.get(i2);
            if (info2 != null) {
                mapping.put(info2.getName(), info2);
            }
            --i2;
        }
        HashMap<BundleInfo, List<BundleInfo>> cache = new HashMap<BundleInfo, List<BundleInfo>>();
        HashSet<BundleInfo> done = new HashSet<BundleInfo>();
        int lastDoneSize = -1;
        while (done.size() < infos.size() && done.size() != lastDoneSize) {
            lastDoneSize = done.size();
            i = infos.size() - 1;
            while (i >= 0) {
                info = infos.get(i);
                if (info != null && !done.contains(info)) {
                    boolean allDone = true;
                    List<BundleInfo> toInit = Utils.getBundlesToInitialize(cache, info, mapping);
                    int j = 0;
                    while (allDone && j < toInit.size()) {
                        BundleInfo init = toInit.get(j);
                        allDone &= info == init || done.contains(init) || init.getName().startsWith("org.eclipse.core.") || init.getName().startsWith("org.eclipse.xtext.");
                        ++j;
                    }
                    if (allDone) {
                        result.add(info);
                        done.add(info);
                    }
                }
                --i;
            }
        }
        i = infos.size() - 1;
        while (i >= 0) {
            info = infos.get(i);
            if (info != null && !done.contains(info)) {
                result.add(info);
            }
            --i;
        }
        int rtVil = -1;
        int ivml = -1;
        int i3 = 0;
        while ((ivml < 0 || rtVil < 0) && i3 < result.size()) {
            BundleInfo info3 = (BundleInfo)result.get(i3);
            if ("de.uni_hildesheim.sse.ivml".equals(info3.getName())) {
                ivml = i3;
            } else if ("de.uni_hildesheim.sse.vil.rt".equals(info3.getName())) {
                rtVil = i3;
            }
            ++i3;
        }
        if (rtVil > 0 && ivml > 0 && rtVil > ivml) {
            BundleInfo info4 = (BundleInfo)result.remove(rtVil);
            result.add(ivml, info4);
        }
        return result;
    }

    private static List<BundleInfo> getBundlesToInitialize(Map<BundleInfo, List<BundleInfo>> cache, BundleInfo info, Map<String, BundleInfo> mapping) {
        List<BundleInfo> result = cache.get(info);
        if (result == null) {
            result = new ArrayList<BundleInfo>();
            Utils.collectBundlesToInitialize(info, result, true, mapping);
            cache.put(info, result);
        }
        return result;
    }

    private static void collectBundlesToInitialize(BundleInfo info, List<BundleInfo> result, boolean topLevel, Map<String, BundleInfo> mapping) {
        if (!(topLevel || info.getActivatorClassName() == null && info.getDsClassesCount() <= 0 || result.contains(info))) {
            result.add(info);
        }
        int r = 0;
        while (r < info.getRequiredBundlesCount()) {
            BundleInfo tmp = mapping.get(info.getRequiredBundle(r).getName());
            if (tmp != null) {
                Utils.collectBundlesToInitialize(tmp, result, false, mapping);
            }
            ++r;
        }
    }

    public static boolean activateDsInstance(ClassLoader loader, String className) {
        return Utils.callMethod(loader, className, "activate", FakeComponentContext.INSTANCE, "DS");
    }

    public static boolean deactivateDsInstance(ClassLoader loader, String className) {
        return Utils.callMethod(loader, className, "deactivate", FakeComponentContext.INSTANCE, "DS");
    }

    private static boolean callMethod(ClassLoader loader, String className, String methodName, Object param, String callType) {
        boolean successful = false;
        try {
            Class<?> cls = loader.loadClass(className);
            Method method = Utils.findMethod(cls, methodName, param);
            Object instance = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (method != null) {
                method.setAccessible(true);
                method.invoke(instance, param);
            }
            successful = true;
        }
        catch (ClassNotFoundException e) {
            Log.warn("Cannot initialize " + className + ": not found");
        }
        catch (NoSuchMethodException e) {
            Log.warn("Cannot initialize " + className + ": non-arg constructor not found");
        }
        catch (IllegalAccessException e) {
            Log.warn("Cannot initialize " + className + ": " + callType + " method " + methodName + " cannot be accessed");
        }
        catch (InstantiationException e) {
            Log.warn("Cannot initialize " + className + ": cannot execute argument-less constructor");
        }
        catch (InvocationTargetException e) {
            String msg = e.getMessage();
            if (e.getCause() != null) {
                msg = e.getCause().getMessage();
            }
            Log.warn("Cannot initialize " + className + ": during " + callType + " " + methodName + " " + msg);
            e.printStackTrace();
        }
        return successful;
    }

    private static Method findMethod(Class<?> cls, String methodName, Object param) {
        Method[] methods = cls.getDeclaredMethods();
        Method method = null;
        int m = 0;
        while (method == null && m < methods.length) {
            Class<?>[] params;
            Method tmp = methods[m];
            if (tmp.getName().equals(methodName) && 1 == (params = tmp.getParameterTypes()).length && params[0].isInstance(param)) {
                method = tmp;
            }
            ++m;
        }
        if (method == null && cls.getSuperclass() != null) {
            method = Utils.findMethod(cls.getSuperclass(), methodName, param);
        }
        return method;
    }

    public static boolean startBundle(ClassLoader loader, String className) {
        return Utils.callMethod(loader, className, "start", FakeBundleContext.INSTANCE, "Activator");
    }

    public static boolean stopBundle(ClassLoader loader, String className) {
        return Utils.callMethod(loader, className, "stop", FakeBundleContext.INSTANCE, "Activator");
    }

    public static void loadBundles(List<File> files, IBundleFilter filter, Object tag) {
        for (File f : files) {
            String fileName = f.getName();
            if (fileName.contains(".source_") || !fileName.endsWith(".jar") || filter != null && !filter.acceptJar(f)) continue;
            try {
                BundleInfo info = BundleInfo.createInstance(f);
                if (info == null) continue;
                info.tag(tag);
            }
            catch (BundleException e) {
                Log.warn("while loading " + String.valueOf(f), e);
            }
        }
    }

    public static List<File> findRecentBundles(File folder) {
        ArrayList<File> result = new ArrayList<File>();
        HashMap<String, JarInfo> map = new HashMap<String, JarInfo>();
        File[] plugins = folder.listFiles();
        if (plugins != null) {
            File[] fileArray = plugins;
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".jar")) {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(f);
                        Manifest manifest = jarFile.getManifest();
                        Attributes attributes = BundleInfo.getAttributes(manifest);
                        String name = BundleInfo.parseSymbolicName(attributes);
                        Version version = BundleInfo.parseVersion(attributes);
                        JarInfo info = (JarInfo)map.get(name);
                        if (info == null || info.version.compareTo(version) < 0) {
                            map.put(name, new JarInfo(version, f));
                        }
                        jarFile.close();
                    }
                    catch (BundleException e) {
                        Utils.closeQuietly(jarFile);
                        Log.warn("while parsing manifest of " + String.valueOf(f) + ": " + e.getMessage());
                    }
                    catch (IOException e) {
                        Utils.closeQuietly(jarFile);
                        Log.warn("while parsing manifest of " + String.valueOf(f) + ": " + e.getMessage());
                    }
                    catch (NumberFormatException e) {
                        Utils.closeQuietly(jarFile);
                        Log.warn("while parsing manifest of " + String.valueOf(f) + ": " + e.getMessage());
                    }
                }
                ++n2;
            }
        }
        for (JarInfo info : map.values()) {
            result.add(info.jar);
        }
        return result;
    }

    public static List<File> findJars(File folder) {
        ArrayList<File> result = new ArrayList<File>();
        File[] plugins = folder.listFiles();
        if (plugins != null) {
            File[] fileArray = plugins;
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".jar")) {
                    result.add(f);
                }
                ++n2;
            }
        }
        return result;
    }

    public static List<BundleInfo> filter(List<BundleInfo> infos, IBundleFilter filter) {
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        for (BundleInfo info : infos) {
            if (!filter.acceptSymbolicName(info.getName())) continue;
            result.add(info);
        }
        return result;
    }

    public static URL[] toURLs(List<File> files) throws MalformedURLException {
        URL[] urls = new URL[files.size()];
        int f = 0;
        while (f < files.size()) {
            urls[f] = files.get(f).toURI().toURL();
            ++f;
        }
        return urls;
    }

    public static void setTempDir(File tempDir) {
        if (temp == null && (tempDir.mkdir() || tempDir.isDirectory())) {
            temp = tempDir;
            temp.deleteOnExit();
        }
    }

    public static File createTempFile(String name) throws IOException {
        if (temp == null) {
            temp = new File(System.getProperty("java.io.tempdir"), "easyLoader");
            temp.delete();
            temp.mkdirs();
            temp.deleteOnExit();
        }
        File result = new File(temp, name);
        result.getParentFile().mkdirs();
        result.deleteOnExit();
        return result;
    }

    public static boolean jarEntryToFile(JarFile jarFile, JarEntry entry, File target) {
        boolean success = false;
        BufferedOutputStream os = null;
        InputStream is = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(target));
            is = jarFile.getInputStream(entry);
            Utils.copy(is, os);
            is.close();
            ((OutputStream)os).close();
            success = true;
        }
        catch (IOException e) {
            Utils.closeQuietly(is);
            Utils.closeQuietly(os);
        }
        return success;
    }

    private static class JarInfo {
        private Version version;
        private File jar;

        JarInfo(Version version, File jar) {
            this.version = version;
            this.jar = jar;
        }
    }
}

