/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse;

import net.ssehub.easy.basics.logger.ILogger;
import net.ssehub.easy.producer.eclipse.DebugStatus;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class EclipseLogger
implements ILogger {
    private ILog logger;

    public EclipseLogger(Plugin plugin) {
        this.logger = plugin.getLog();
    }

    public void info(String msg, Class<?> clazz, String bundleName) {
        msg = "[INFO] [" + clazz.getSimpleName() + "] " + (String)msg;
        try {
            this.logger.log((IStatus)new Status(1, bundleName, (String)msg));
        }
        catch (IllegalArgumentException e) {
            System.out.println((String)msg);
        }
    }

    public void error(String msg, Class<?> clazz, String bundleName) {
        msg = "[ERROR] [" + clazz.getSimpleName() + "] " + (String)msg;
        try {
            this.logger.log((IStatus)new Status(4, bundleName, (String)msg));
        }
        catch (IllegalArgumentException e) {
            System.out.println((String)msg);
        }
    }

    public void warn(String msg, Class<?> clazz, String bundleName) {
        msg = "[WARNING] [" + clazz.getSimpleName() + "] " + (String)msg;
        try {
            this.logger.log((IStatus)new Status(2, bundleName, (String)msg));
        }
        catch (IllegalArgumentException e) {
            System.out.println((String)msg);
        }
    }

    public void debug(String msg, Class<?> clazz, String bundleName) {
        msg = "[DEBUG] [" + clazz.getSimpleName() + "] " + (String)msg;
        try {
            this.logger.log((IStatus)new DebugStatus(bundleName, (String)msg));
        }
        catch (IllegalArgumentException e) {
            System.out.println((String)msg);
        }
    }

    public void exception(String msg, Class<?> clazz, String bundleName) {
        msg = "[EXCEPTION] [" + clazz.getSimpleName() + "] " + (String)msg;
        try {
            this.logger.log((IStatus)new DebugStatus(bundleName, (String)msg));
        }
        catch (IllegalArgumentException e) {
            System.out.println((String)msg);
        }
    }
}

