/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.ant.instantiators;

import java.io.File;
import java.util.ArrayList;
import net.ssehub.easy.instantiation.ant.instantiators.CustomAntLogger;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.AbstractFileInstantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

@Instantiator(value="ant")
public class Ant
extends AbstractFileInstantiator {
    private static final String XML_TYPE = ".xml";
    private static final CustomAntLogger CONSOLE_LOGGER = new CustomAntLogger();
    private static final int ERR_PRIO = 0;
    private static final int MSG_PRIO = 2;

    @ReturnGenerics(value={FileArtifact.class})
    public static Set<FileArtifact> ant(Path root, String buildFilePath, String buildtarget) throws VilException {
        File buildFile = new File(root.getAbsolutePath(), buildFilePath);
        String fullBuildFilePath = buildFile.getAbsolutePath();
        long timestamp = PathUtils.normalizedTime();
        File targetPath = Ant.determineTargetPath((Path)root);
        if (!buildFile.exists() || !fullBuildFilePath.endsWith(XML_TYPE)) {
            throw new VilException("buildfile '" + fullBuildFilePath + "' does not exists or is not valid", 30008);
        }
        buildFile = new File(fullBuildFilePath);
        Project p = new Project();
        Ant.antDebugging(p);
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        try {
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(buildtarget);
            p.fireBuildFinished(null);
        }
        catch (Exception e) {
            p.fireBuildFinished((Throwable)e);
            throw new VilException(e.getMessage(), 30012);
        }
        if (CONSOLE_LOGGER.getMessages().containsKey(0)) {
            throw new VilException("ANT: " + CONSOLE_LOGGER.getMessages().get(2) + " " + CONSOLE_LOGGER.getMessages().get(0), 30008);
        }
        ArrayList result = new ArrayList();
        FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
        FileUtils.scan((File)targetPath.getAbsoluteFile(), (ArtifactModel)root.getArtifactModel(), (long)timestamp, (FileUtils.ScanResult)scanResult, FileArtifact.class);
        scanResult.checkForException();
        return new ListSet(result, FileArtifact.class);
    }

    private static void antDebugging(Project project) {
        CONSOLE_LOGGER.setErrorPrintStream(System.err);
        CONSOLE_LOGGER.setOutputPrintStream(System.out);
        CONSOLE_LOGGER.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)CONSOLE_LOGGER);
    }
}

