/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.CompoundVariable;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.paths.IResolutionPathElement;
import net.ssehub.easy.varModel.confModel.paths.StartPathElement;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IValueParent;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

public class LocalDecisionVariable
implements IDecisionVariable {
    static final String ITERATOR_RESULT_VARNAME = "*r*";
    private DecisionVariableDeclaration decl;
    private Value value;
    private IAssignmentState state;
    private IConfiguration conf;
    private IDecisionVariable parent;
    private IValueChangeListener listener;

    public LocalDecisionVariable(DecisionVariableDeclaration decl, IConfiguration conf, IDecisionVariable parent) {
        this.decl = decl;
        this.state = AssignmentState.UNDEFINED;
        this.conf = conf;
        this.parent = parent;
    }

    @Override
    public IConfigurationElement getParent() {
        return this.parent;
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public IAssignmentState getState() {
        return this.state;
    }

    private void notifyValueChanged(Value oldValue, IAssignmentState oldState, IValueChangeListener.ChangeKind kind) {
        if (this.listener != null) {
            this.listener.notifyChanged(this, oldValue, oldState, kind);
        }
    }

    @Override
    public void setValue(Value value, IAssignmentState state, boolean asAssignment) throws ConfigurationException {
        IDecisionVariable nested;
        IDecisionVariable decVar;
        IValueParent vParent = asAssignment ? this.obtainValueParent(value) : null;
        Value oldValue = this.value;
        IAssignmentState oldState = this.state;
        this.value = value;
        this.state = state;
        if (this.parent != null && vParent instanceof IDecisionVariable && Compound.TYPE.isAssignableFrom((decVar = (IDecisionVariable)vParent).getDeclaration().getType()) && (nested = decVar.getNestedElement(this.decl.getName())) != null) {
            decVar.setValue(value, state, nested);
        }
        this.notifyValueChanged(oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
    }

    @Override
    public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        Value oldValue = this.value;
        IAssignmentState oldState = this.state;
        this.value = value;
        this.state = state;
        this.notifyValueChanged(oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
    }

    @Override
    public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        IAssignmentState oldState = this.state;
        Value oldValue = this.value;
        this.value = value;
        this.state = state;
        this.notifyValueChanged(oldValue, oldState, IValueChangeListener.ChangeKind.FULL);
    }

    private IValueParent obtainValueParent(Value value) {
        IValueParent result = this.getValueParent(this.value);
        if (result == null) {
            result = this.getValueParent(value);
        }
        if (result == null) {
            IDecisionVariable iter = this.parent;
            while (iter != null && result == null) {
                result = this.getValueParent(iter.getValue());
                iter = iter.getParent() instanceof IDecisionVariable ? (IDecisionVariable)iter.getParent() : null;
            }
        }
        return result;
    }

    private IValueParent getValueParent(Value value) {
        return value == null ? null : value.getValueParent();
    }

    @Override
    public void freeze(IFreezeSelector selector) {
    }

    @Override
    public void unfreeze(IAssignmentState state) {
    }

    @Override
    public void freeze(String nestedElement) {
    }

    @Override
    public AbstractVariable getDeclaration() {
        return this.decl;
    }

    @Override
    public void accept(IConfigurationVisitor visitor) {
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
    }

    @Override
    public int getNestedElementsCount() {
        int result = this.parent != null ? this.parent.getNestedElementsCount() : (this.value instanceof ContainerValue ? ((ContainerValue)this.value).getElementSize() : (this.value instanceof CompoundValue ? ((Compound)this.value.getType()).getElementCount() : 0));
        return result;
    }

    @Override
    public IDecisionVariable getNestedElement(int index) {
        IDecisionVariable result;
        if (this.parent != null) {
            result = this.parent.getNestedElement(index);
        } else if (this.value instanceof ContainerValue) {
            Value cValue = ((ContainerValue)this.value).getElement(index);
            Container par = null;
            IDatatype cType = cValue.getType();
            if (cType instanceof Container) {
                cType = ((Container)cType).getContainedType();
                par = (Container)cType;
            }
            LocalDecisionVariable var = new LocalDecisionVariable(new DecisionVariableDeclaration(String.valueOf(index), cType, par), this.conf, this);
            try {
                var.setValue(cValue, AssignmentState.ASSIGNED);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            result = var;
        } else if (this.value instanceof CompoundValue) {
            CompoundValue cValue = (CompoundValue)this.value;
            Compound type = (Compound)cValue.getType();
            DecisionVariableDeclaration slotDecl = type.getElement(index);
            LocalDecisionVariable var = new LocalDecisionVariable(slotDecl, this.conf, this);
            Value slotValue = cValue.getNestedValue(slotDecl.getName());
            try {
                var.setValue(slotValue, AssignmentState.ASSIGNED);
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            result = var;
        } else {
            result = null;
        }
        return result;
    }

    public IDecisionVariable getNestedVariable(String slotName) {
        IDecisionVariable result = null;
        if (this.parent instanceof CompoundVariable) {
            result = ((CompoundVariable)this.parent).getNestedVariable(slotName);
        } else {
            CompoundValue cValue;
            Compound type;
            DecisionVariableDeclaration slotDecl;
            Value tmp = Configuration.dereference(this.conf, this.value);
            if (tmp instanceof CompoundValue && (slotDecl = (type = (Compound)(cValue = (CompoundValue)tmp).getType()).getElement(slotName)) != null) {
                Value slotValue = cValue.getNestedValue(slotName);
                if (!Reference.TYPE.isAssignableFrom(slotDecl.getType())) {
                    slotValue = Configuration.dereference(this.conf, slotValue);
                }
                LocalDecisionVariable var = new LocalDecisionVariable(slotDecl, this.conf, this);
                if (slotValue != null) {
                    try {
                        var.setValue(slotValue, AssignmentState.ASSIGNED);
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }
                result = var;
            }
        }
        return result;
    }

    @Override
    public IDecisionVariable getNestedElement(String name) {
        return Configuration.getNestedElement(this, name);
    }

    @Override
    public int getAttributesCount() {
        return this.parent != null ? this.parent.getAttributesCount() : 0;
    }

    @Override
    public IDecisionVariable getAttribute(int index) {
        if (this.parent != null) {
            return this.parent.getAttribute(index);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getNestedDepth() {
        return 0;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean hasNullValue() {
        return NullValue.INSTANCE == this.value;
    }

    @Override
    public boolean removeDerivedValues() {
        return false;
    }

    @Override
    public String getQualifiedName() {
        return this.getDeclaration().getQualifiedName();
    }

    @Override
    public IResolutionPathElement getResolutionPath() {
        return new StartPathElement(this.getDeclaration());
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public void setVariable(IDecisionVariable variable) {
        this.parent = variable;
    }

    public IDecisionVariable getVariable() {
        return this.parent;
    }

    public void setValueChangeListener(IValueChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean wasCreated() {
        return true;
    }

    @Override
    public void notifyCreated() {
    }

    @Override
    public boolean notifyWasAssigned(Value value) {
        return false;
    }

    @Override
    public boolean wasAssigned() {
        return true;
    }

    @Override
    public boolean enableWasAssignedForIsDefined() {
        return false;
    }
}

