/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.datatypes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;

public class CustomOperation
extends Operation {
    private ConstraintSyntaxTree function;
    private DecisionVariableDeclaration[] parameters;
    private Map<String, DecisionVariableDeclaration> namedParameters;
    private String[] annotations;

    CustomOperation() {
    }

    public CustomOperation(IDatatype returns, String methodname, IDatatype operand, ConstraintSyntaxTree function, DecisionVariableDeclaration[] parameters) {
        super(returns, methodname, operand, CustomOperation.getParameterTypes(parameters));
        this.parameters = parameters;
        this.function = function;
        if (parameters != null) {
            int p = 0;
            while (p < parameters.length) {
                DecisionVariableDeclaration dvd = parameters[p];
                if (dvd.getDefaultValue() != null) {
                    if (this.namedParameters == null) {
                        this.namedParameters = new HashMap<String, DecisionVariableDeclaration>();
                    }
                    this.namedParameters.put(dvd.getName(), dvd);
                }
                ++p;
            }
        }
    }

    public void setFunction(ConstraintSyntaxTree function) throws CSTSemanticException {
        IDatatype fType = function.inferDatatype();
        if (!this.getReturns().isAssignableFrom(fType)) {
            throw new CSTSemanticException("type of implementation expression '" + IvmlDatatypeVisitor.getQualifiedType(fType) + " does not comply to return type '" + IvmlDatatypeVisitor.getQualifiedType(this.getReturns()) + "'.", 10100);
        }
        this.function = function;
    }

    private static IDatatype[] getParameterTypes(DecisionVariableDeclaration[] decl) {
        IDatatype[] result;
        if (decl == null) {
            result = null;
        } else {
            result = new IDatatype[decl.length];
            int d = 0;
            while (d < decl.length) {
                result[d] = decl[d].getType();
                ++d;
            }
        }
        return result;
    }

    @Override
    public ConstraintSyntaxTree getFunction() {
        return this.function;
    }

    @Override
    public DecisionVariableDeclaration getParameterDeclaration(int index) {
        if (this.parameters == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.parameters[index];
    }

    @Override
    public DecisionVariableDeclaration getParameter(String name) {
        DecisionVariableDeclaration result;
        DecisionVariableDeclaration decisionVariableDeclaration = result = this.namedParameters == null ? null : this.namedParameters.get(name);
        if (result == null) {
            int p = 0;
            while (result == null && p < this.getParameterCount()) {
                DecisionVariableDeclaration dvd = this.getParameterDeclaration(p);
                if (dvd.getName().equals(name)) {
                    result = dvd;
                }
                ++p;
            }
        }
        return result;
    }

    @Override
    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    @Override
    public int getRequiredParameterCount() {
        int paramCount = this.getParameterCount();
        return this.namedParameters == null ? paramCount : paramCount - this.namedParameters.size();
    }

    public void setAnnotations(List<String> annotations) {
        if (annotations != null) {
            this.annotations = annotations.toArray(new String[annotations.size()]);
        }
    }

    public int getAnnotationCount() {
        return this.annotations == null ? 0 : this.annotations.length;
    }

    public String getAnnotation(int index) {
        if (this.annotations == null) {
            throw new IndexOutOfBoundsException("no annotations defined");
        }
        return this.annotations[index];
    }

    public boolean hasAnnotation(String annotation) {
        return CustomOperation.hasAnnotation(this.annotations, annotation);
    }

    public static boolean hasAnnotation(String[] annotations, String annotation) {
        boolean found = false;
        if (annotations != null) {
            int i = 0;
            while (!found && i < annotations.length) {
                found = annotations[i].equalsIgnoreCase(annotation);
                ++i;
            }
        }
        return found;
    }

    @Override
    protected boolean registerAsOperation() {
        return false;
    }
}

