/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.rewrite.VariableLookUpTable;

public class RewriteContext {
    private Set<String> projectQualifier;
    private Map<Class<?>, Set<ContainableModelElement>> removedElements = new HashMap();
    private Map<String, List<ContainableModelElement>> elementsOfRemovedImports = new HashMap<String, List<ContainableModelElement>>();
    private boolean elementsWereRemoved = false;
    private VariableLookUpTable variablesTable;

    protected RewriteContext() {
        this.projectQualifier = new HashSet<String>();
        this.variablesTable = new VariableLookUpTable();
    }

    VariableLookUpTable getLookUpTable() {
        return this.variablesTable;
    }

    private String generateQualifiedName(Project project) {
        Version v = project.getVersion();
        return v == null ? project.getName() : project.getName() + "+" + v.getVersion();
    }

    public void removeElement(ContainableModelElement removedElememt) {
        this.elementsWereRemoved = true;
        Class<?> modelElementType = removedElememt.getClass();
        Set<ContainableModelElement> removedElementList = this.removedElements.get(modelElementType);
        if (removedElementList == null) {
            removedElementList = new HashSet<ContainableModelElement>();
            this.removedElements.put(modelElementType, removedElementList);
        }
        removedElementList.add(removedElememt);
    }

    public boolean elementWasRemoved(ContainableModelElement elememt) {
        Class<?> elementType = elememt.getClass();
        Set<ContainableModelElement> removedElementList = this.removedElements.get(elementType);
        return removedElementList != null && removedElementList.contains(elememt);
    }

    public boolean hasRemovedElementsOfType(Class<? extends ContainableModelElement> type) {
        Set<ContainableModelElement> removedElementList = this.removedElements.get(type);
        return removedElementList != null && !removedElementList.isEmpty();
    }

    public boolean elementesWereRemoved() {
        return this.elementsWereRemoved;
    }

    void clear() {
        this.elementsWereRemoved = false;
        this.elementsOfRemovedImports.clear();
    }

    void newRun() {
        this.clear();
        this.elementsWereRemoved = true;
    }

    public boolean projectIsStillPresent(Project project) {
        String qName = this.generateQualifiedName(project);
        return this.projectQualifier.contains(qName);
    }

    void markForImportRemoval(Project declaringProject, ContainableModelElement nestedElement) {
        String qName = this.generateQualifiedName(declaringProject);
        List<ContainableModelElement> elementsOfProject = this.elementsOfRemovedImports.get(qName);
        if (elementsOfProject == null) {
            elementsOfProject = new ArrayList<ContainableModelElement>();
            this.elementsOfRemovedImports.put(qName, elementsOfProject);
        }
        elementsOfProject.add(nestedElement);
    }

    void removeElementsOfRemovedImports() {
        for (String qName : this.elementsOfRemovedImports.keySet()) {
            List<ContainableModelElement> elementsOfProject = this.elementsOfRemovedImports.get(qName);
            if (this.projectQualifier.contains(qName) || elementsOfProject == null) continue;
            int i = 0;
            int n = elementsOfProject.size();
            while (i < n) {
                this.removeElement(elementsOfProject.get(i));
                ++i;
            }
        }
    }

    public Set<IDecisionVariable> getInstancesForType(Configuration config, IDatatype type) {
        return this.variablesTable.getInstancesForType(type);
    }

    public Set<IDecisionVariable> getInstancesForDeclaration(Configuration config, AbstractVariable declaration) {
        return this.variablesTable.getInstancesForDeclaration(declaration);
    }

    boolean declarationKnown(AbstractVariable declaration) {
        return this.variablesTable.declarationKnown(declaration);
    }

    public void addUsedProject(Project project) {
        String qName = this.generateQualifiedName(project);
        this.projectQualifier.add(qName);
    }
}

