/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.values;

import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.values.BasisDatatypeValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class VersionValue
extends BasisDatatypeValue {
    private Version value;

    protected VersionValue(Object value) throws ValueDoesNotMatchTypeException {
        super(VersionType.TYPE);
        this.setValue(value);
    }

    protected VersionValue() {
        super(VersionType.TYPE);
    }

    protected VersionValue(Version value) {
        super(VersionType.TYPE);
        this.value = value;
    }

    public Version getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws ValueDoesNotMatchTypeException {
        if (value instanceof Version) {
            this.value = (Version)value;
        } else if (value != null) {
            String sValue = this.stringValueOf(value);
            if (sValue.startsWith("v")) {
                sValue = sValue.substring(1);
            }
            try {
                this.value = new Version(sValue);
            }
            catch (VersionFormatException e) {
                throw new ValueDoesNotMatchTypeException(sValue, this, 10203);
            }
        } else {
            this.value = Version.NULL_VALUE;
        }
    }

    @Override
    public boolean isConfigured() {
        return this.value != null;
    }

    @Override
    public void accept(IValueVisitor visitor) {
        visitor.visitVersionValue(this);
    }

    @Override
    public Value clone() {
        return new VersionValue(this.value);
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (this.value != null && object instanceof VersionValue) {
            result = this.value.equals((Object)((VersionValue)object).getValue());
        }
        return result;
    }
}

