/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeImport;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeTypeSpec;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAlternative;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeArtifactCreator;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAssert;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAssign;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeClass;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDelete;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDocComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeEnum;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFnCall;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeForLoop;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFunction;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImport;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeMatch;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeRaise;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTryBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTypeAlias;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeWhileLoop;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeWith;
import net.ssehub.easy.instantiation.python.codeArtifacts.Storable;

@ArtifactCreator(value=PythonCodeArtifactCreator.class)
public class PythonCodeArtifact
extends FileArtifact
implements IPythonCodeArtifact,
IStringValueProvider,
Storable {
    private List<IPythonCodeImport> imports = new ArrayList<IPythonCodeImport>();
    private PythonCodeBlock block;
    private PythonCodeDocComment comment;
    private File file;
    private String moduleName = "";
    private boolean store = false;

    public PythonCodeArtifact(File file, ArtifactModel model) {
        super(file, model);
        this.file = file;
        if (file != null) {
            this.moduleName = file.getName().replace(".py", "");
        }
        this.store = true;
        this.block = new PythonCodeBlock(this);
    }

    public PythonCodeArtifact(String moduleName) {
        this(null, null);
        this.moduleName = moduleName;
        this.store = false;
    }

    public static PythonCodeArtifact create(String moduleName) {
        return new PythonCodeArtifact(moduleName);
    }

    @Invisible
    public boolean enableAutoStore() {
        return false;
    }

    @Invisible
    public boolean enableContentStore() {
        return this.block.getElementCount() == 0;
    }

    public PythonCodeArtifact disable() {
        this.store = false;
        return this;
    }

    public PythonCodeArtifact enable() {
        this.store = true;
        return this;
    }

    @Invisible
    @Conversion
    public static FileArtifact convert(String val) throws VilException {
        Path path = Path.convert((String)val);
        return (FileArtifact)ArtifactFactory.createArtifact(PythonCodeArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    @Invisible
    @Conversion
    public static PythonCodeArtifact convert(IFileSystemArtifact val) {
        PythonCodeArtifact convertedValue = null;
        if (val instanceof PythonCodeArtifact) {
            convertedValue = (PythonCodeArtifact)val;
        } else if (val instanceof FileArtifact) {
            FileArtifact fa = (FileArtifact)val;
            try {
                convertedValue = (PythonCodeArtifact)ArtifactFactory.createArtifact(PythonCodeArtifact.class, (Object)fa.getPath().getAbsolutePath(), null);
                fa.setEnableContentStore(false);
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(PythonCodeArtifact.class, "net.ssehub.easy.instantiation.core").error(e.getMessage());
            }
        }
        return convertedValue;
    }

    @Invisible
    @Conversion
    public static PythonCodeArtifact convert(Path path) throws VilException {
        return (PythonCodeArtifact)ArtifactFactory.createArtifact(PythonCodeArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    public Object determineActualValue(Object object) {
        Object result = object;
        if (!(object instanceof PythonCodeArtifact) && object instanceof FileArtifact) {
            result = PythonCodeArtifact.convert((IFileSystemArtifact)object);
        }
        return super.determineActualValue(result);
    }

    public String getModule() {
        return this.moduleName;
    }

    @Override
    public int getElementCount() {
        int result = 0;
        if (this.comment != null) {
            result += this.comment.getElementCount();
        }
        return result += this.block.getElementCount();
    }

    public String toImports() {
        return Storable.getString(o -> this.storeImports((CodeWriter)o));
    }

    public String toHeader() {
        return Storable.getString(o -> this.storeHeader((CodeWriter)o));
    }

    protected void storeImports(CodeWriter out) {
        for (IPythonCodeImport imp : this.imports) {
            imp.store(out);
        }
    }

    protected void storeHeader(CodeWriter out) {
        if (this.comment != null) {
            this.comment.store(out);
            out.println();
        }
    }

    @Invisible
    public void store() throws VilException {
        if (this.store && (this.imports.size() > 0 || this.block.getElementCount() > 0)) {
            CodeWriter out = new CodeWriter(this.file);
            this.store(out);
            out.close();
        } else {
            super.store();
        }
    }

    @Override
    public void store(CodeWriter out) {
        this.storeHeader(out);
        this.block.store(out);
    }

    @OperationMeta(storeArtifactsBefore=true)
    public void delete() throws VilException {
        super.delete();
    }

    @OperationMeta(name={"comment"})
    public PythonCodeArtifact setComment(String comment) {
        this.comment = new PythonCodeDocComment(comment, null);
        return this;
    }

    public void add(String text) {
        this.block.add(text);
    }

    public void addRaw(String text, boolean indent) {
        this.block.addRaw(text, indent);
    }

    public PythonCodeClass addClass(String name) {
        return this.block.addClass(name);
    }

    public PythonCodeClass addClass(String name, String comment) {
        return this.block.addClass(name, comment);
    }

    public PythonCodeEnum addEnum(String name) {
        return this.block.addEnum(name);
    }

    public PythonCodeEnum addEnum(String name, String comment) {
        return this.block.addEnum(name, comment);
    }

    @OperationMeta(name={"addAssign", "addAssignment", "assign"})
    public PythonCodeAssign addAssign(String varName, String expr) {
        return this.block.addAssign(varName, expr);
    }

    @OperationMeta(name={"addAssign", "addAssignment", "assign"})
    public PythonCodeAssign addAssign(String varName, String type, String expr) {
        return this.block.addAssign(varName, type, expr);
    }

    public PythonCodeMatch addMatch(String expr) {
        return this.block.addMatch(expr);
    }

    @Override
    public PythonCodeFunction addFunc(String name) {
        return this.block.addFunc(name);
    }

    @Override
    public PythonCodeFunction addFunc(String name, String comment) {
        return this.block.addFunc(name, comment);
    }

    public PythonCodeFnCall addSysPathInsert(int position, String path) {
        this.addImport("sys");
        return this.addCall("sys.path.insert").addArgument(position).addStringArgument(path);
    }

    public PythonCodeTypeAlias addTypeAlias(String name, String expr) {
        return this.block.addTypeAlias(name, expr);
    }

    public PythonCodeFnCall addCall(String name) {
        return this.addCall(name, PythonCodeImportScope.NONE);
    }

    public PythonCodeFnCall addCall(String name, PythonCodeImportScope scope) {
        return this.block.addCall(name, scope);
    }

    public PythonCodeBlock addComment(String comment) {
        return this.block.addComment(comment);
    }

    public PythonCodeBlock addSLComment(String comment) {
        return this.block.addSLComment(comment);
    }

    public PythonCodeBlock addSLComment(String comment, boolean enclosed) {
        return this.block.addSLComment(comment, enclosed);
    }

    public void addEmptyLine() {
        this.block.addEmptyLine();
    }

    public PythonCodeForLoop addFor(String element, String array) {
        return this.block.addFor(element, array);
    }

    public PythonCodeForLoop addFor(String element, String rangeStart, String rangeEnd) {
        return this.block.addFor(element, rangeStart, rangeEnd);
    }

    public PythonCodeForLoop addFor(String element, String rangeStart, String rangeEnd, String rangeStep) {
        return this.block.addFor(element, rangeStart, rangeEnd, rangeStep);
    }

    public PythonCodeAlternative addIf(String condition) {
        return this.block.addIf(condition);
    }

    public PythonCodeWhileLoop addWhile(String condition) {
        return this.block.addWhile(condition);
    }

    public PythonCodeTryBlock addTry() {
        return this.block.addTry();
    }

    public PythonCodeRaise addRaise(String expr) {
        return this.block.addRaise(expr);
    }

    public PythonCodeWith addWith(String expr) {
        return this.block.addWith(expr);
    }

    public PythonCodeWith addWith(String expr, String varName) {
        return this.block.addWith(expr, varName);
    }

    public PythonCodeDelete addDelete(String varName) {
        return this.block.addDelete(varName);
    }

    public PythonCodeAssert addAssert(String expr) {
        return this.block.addAssert(expr);
    }

    public PythonCodeAssert addAssert(String expr, String msg) {
        return this.block.addAssert(expr, msg);
    }

    @Override
    public PythonCodeImport addImport(String imp) {
        IPythonCodeImport found = this.findMatchingImport(imp);
        if (found != null && found instanceof PythonCodeImport) {
            return (PythonCodeImport)found;
        }
        return new PythonCodeImport(this, imp, true);
    }

    @Override
    public PythonCodeImport addImport(String from, String imp) {
        IPythonCodeImport found = this.findMatchingImport(from);
        if (found != null && found instanceof PythonCodeImport) {
            return (PythonCodeImport)found;
        }
        return new PythonCodeImport(this, from, imp, true);
    }

    private IPythonCodeImport findMatchingImport(String imp) {
        for (IPythonCodeImport i : this.imports) {
            String iName = i.getName();
            boolean found = false;
            if (i.isWildcard()) {
                String impPrefix = "";
                int pos = imp.lastIndexOf(46);
                if (pos > 0) {
                    impPrefix = imp.substring(0, pos);
                }
                if (impPrefix.length() > 0) {
                    found = impPrefix.equals(iName.substring(0, iName.length() - 1));
                }
            } else {
                found = iName.equals(imp);
            }
            if (!found) continue;
            return i;
        }
        return null;
    }

    @Override
    public void validateType(IPythonCodeTypeSpec type) {
        String typeName = type.getOutputTypeName();
        int pos = typeName.lastIndexOf(46);
        if (pos > 0) {
            if (this.findMatchingImport(typeName) == null) {
                new PythonCodeImport(this, typeName, false);
            }
            type.setOutputTypeName(typeName.substring(pos + 1));
        }
    }

    @Override
    public String validateFuncCall(String name, PythonCodeImportScope scope) {
        if (scope == PythonCodeImportScope.NONE) {
            return name;
        }
        int modulePos = name.lastIndexOf(46);
        if (modulePos < 0) {
            return name;
        }
        String module = name.substring(0, modulePos);
        String fnName = name.substring(modulePos + 1);
        switch (scope) {
            case FUNC: {
                if (this.findMatchingImport(name) == null) {
                    new PythonCodeImport(this, module, fnName, false);
                }
                return fnName;
            }
            case MODULE: {
                int nestedModulePos = module.lastIndexOf(46);
                fnName = nestedModulePos > 0 ? name.substring(nestedModulePos + 1) : name;
                if (this.findMatchingImport(name) == null) {
                    new PythonCodeImport(this, module, false);
                }
                return fnName;
            }
        }
        return name;
    }

    @Override
    public void registerImport(IPythonCodeImport imp, boolean explicit) {
        if (!this.imports.stream().anyMatch(i -> i.match(imp))) {
            this.imports.add(imp);
            this.block.addElt(imp, !explicit);
        }
    }

    @Override
    @Invisible
    public void moveToImports(IPythonCodeImport imp) {
        this.block.moveToImports(imp);
    }
}

