/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;

public class PythonCodeDocComment
implements IPythonCodeElement {
    private String comment = "";
    private IPythonCodeElement attachedTo;
    private List<ParamComment> params = new ArrayList<ParamComment>();
    private ReturnComment returnComment;

    public PythonCodeDocComment(IPythonCodeElement attachedTo) {
        this.comment = "";
        this.attachedTo = attachedTo;
    }

    public PythonCodeDocComment(String comment, IPythonCodeElement attachedTo) {
        this.comment = comment;
        this.attachedTo = attachedTo;
        if (this.comment == null) {
            this.comment = "";
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void store(CodeWriter out) {
        if (this.comment.isEmpty() && this.params.isEmpty() && this.returnComment == null) {
            return;
        }
        out.printwi("\"\"\"");
        if (!this.comment.isEmpty()) {
            out.print(this.comment.replace("\\n", "\n").replace("\\r", "\r"));
            if (this.params.isEmpty() && this.returnComment == null) {
                out.println("\"\"\"");
                return;
            }
        }
        out.println();
        if (!this.params.isEmpty()) {
            out.printlnwi("Parameters:");
            out.increaseIndent();
            for (ParamComment p : this.params) {
                p.store(out);
            }
            out.decreaseIndent();
        }
        if (this.returnComment != null) {
            this.returnComment.store(out);
        }
        out.printlnwi("\"\"\"");
    }

    @Override
    public int getElementCount() {
        int res = 0;
        if (this.comment != null) {
            int lines = this.comment.length() - this.comment.replace("\\n", "").length();
            res += 1 + lines;
        }
        return res;
    }

    public PythonCodeDocComment addParameterComment(String name, String comment) {
        this.params.add(new ParamComment(name, null, comment));
        return this;
    }

    public PythonCodeDocComment addParameterComment(String name, String type, String comment) {
        this.params.add(new ParamComment(name, type, comment));
        return this;
    }

    public PythonCodeDocComment addReturnComment(String comment) {
        if (this.returnComment == null) {
            this.returnComment = new ReturnComment(comment);
        } else {
            this.returnComment.comment = comment;
        }
        return this;
    }

    public PythonCodeDocComment addReturnType(String type) {
        if (this.returnComment == null) {
            this.returnComment = new ReturnComment("");
        }
        this.returnComment.setType(type);
        return this;
    }

    @Override
    public IPythonCodeArtifact getArtifact() {
        return null;
    }

    @Override
    public IPythonCodeElement getParent() {
        return null;
    }

    @Override
    public void setParent(IPythonCodeElement parent) {
    }

    private class ParamComment {
        private String name;
        private String comment;
        private String type;

        private ParamComment(String name, String type, String comment) {
            this.name = name;
            this.comment = comment;
            this.type = type;
        }

        public void store(CodeWriter out) {
            out.printwi("- " + this.name);
            if (this.type != null && !this.type.isEmpty()) {
                out.print(" (" + this.type + ")");
            }
            if (!this.comment.isEmpty()) {
                out.print(" -- " + this.comment);
            }
            out.println();
        }
    }

    private class ReturnComment {
        private String comment;
        private String type;

        private ReturnComment(String comment) {
            this.comment = comment;
        }

        private void setType(String type) {
            this.type = type;
        }

        public void store(CodeWriter out) {
            out.printlnwi("Returns:");
            out.increaseIndent();
            if (this.type != null && !this.type.isEmpty()) {
                out.printlnwi(this.type);
                out.increaseIndent();
                out.printlnwi(this.comment);
                out.decreaseIndent();
            } else {
                out.printlnwi(this.comment);
            }
            out.decreaseIndent();
        }
    }
}

