/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeConstructorCall;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeExpr;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeLambdaExpr;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeText;
import org.apache.commons.lang.StringEscapeUtils;

public class PythonCodeFnCall
extends PythonCodeExpr {
    private String name;
    private List<IPythonCodeElement> arguments = new ArrayList<IPythonCodeElement>();
    private PythonCodeFnCall chained;
    private boolean usedAsStmt;

    public PythonCodeFnCall(IPythonCodeElement parent, String name, PythonCodeImportScope scope) {
        super(parent);
        this.usedAsStmt = false;
        this.name = this.validateFuncName(parent, name, scope);
    }

    public PythonCodeFnCall(IPythonCodeElement parent, String name, PythonCodeImportScope scope, boolean usedAsStmt) {
        super(parent);
        this.usedAsStmt = usedAsStmt;
        this.name = this.validateFuncName(parent, name, scope);
    }

    public int getArgumentsCount() {
        return this.arguments.size();
    }

    public String getFuncName() {
        return this.name;
    }

    protected String validateFuncName(IPythonCodeElement parent, String name, PythonCodeImportScope scope) {
        if (scope != PythonCodeImportScope.NONE && name.contains(".")) {
            return parent.getArtifact().validateFuncCall(name, scope);
        }
        return name;
    }

    public PythonCodeFnCall addArgument(Object arg) {
        return this.addArgument(null, arg);
    }

    public PythonCodeFnCall addArgument(String pName, Object arg) {
        if (Boolean.TRUE == arg) {
            arg = "True";
        } else if (Boolean.FALSE == arg) {
            arg = "False";
        }
        this.wrapNAdd(pName, new PythonCodeText(arg.toString(), false, false));
        return this;
    }

    public PythonCodeFnCall addArgument(String arg) {
        return this.addArgument(null, arg);
    }

    public PythonCodeFnCall addArgument(String pName, String arg) {
        this.wrapNAdd(pName, new PythonCodeText(arg, false, false));
        return this;
    }

    public PythonCodeFnCall addArgument(String fnName, PythonCodeImportScope scope) {
        return this.addArgument(null, fnName, scope);
    }

    public PythonCodeFnCall addArgument(String pName, String fnName, PythonCodeImportScope scope) {
        return this.wrapNAdd(pName, new PythonCodeFnCall(this, fnName, scope));
    }

    public PythonCodeFnCall addStringArgument(String val) {
        return this.addStringArgument(null, val);
    }

    public PythonCodeFnCall addStringArgument(String pName, String val) {
        return this.addArgument(pName, "\"" + StringEscapeUtils.escapeJava((String)val) + "\"");
    }

    public PythonCodeLambdaExpr addLambdaArgument() {
        return this.addLambdaArgument(null);
    }

    public PythonCodeLambdaExpr addLambdaArgument(String pName) {
        return this.wrapNAdd(pName, new PythonCodeLambdaExpr(this));
    }

    public PythonCodeConstructorCall addConstructorCall(String cls) {
        return this.addConstructorCall(null, cls);
    }

    public PythonCodeConstructorCall addConstructorCall(String pName, String cls) {
        return this.wrapNAdd(pName, new PythonCodeConstructorCall(this, cls));
    }

    private <T extends IPythonCodeElement> T wrapNAdd(String pName, T elt) {
        this.arguments.add((IPythonCodeElement)(pName == null || pName.length() == 0 ? elt : new NamedArgument(this, pName, elt)));
        return elt;
    }

    public PythonCodeFnCall addCall(String fnName) {
        return this.addCall(fnName, PythonCodeImportScope.NONE);
    }

    public PythonCodeFnCall addCall(String fnName, PythonCodeImportScope scope) {
        this.chained = new PythonCodeFnCall(this, fnName, scope);
        return this.chained;
    }

    @Override
    public void store(CodeWriter out) {
        if (this.usedAsStmt) {
            out.printwi("");
        }
        out.print(this.name);
        this.storeArgumentList(out);
        if (this.chained != null) {
            out.print(".");
            this.chained.store(out);
        }
        if (this.usedAsStmt) {
            out.println();
        }
    }

    protected void storeArgumentList(CodeWriter out) {
        out.print("(");
        IPythonCodeElement.storeList(this.arguments, ",", out);
        out.print(")");
    }

    private static class NamedArgument
    extends PythonCodeElement {
        private String pName;
        private IPythonCodeElement value;

        protected NamedArgument(IPythonCodeElement parent, String pName, IPythonCodeElement value) {
            super(parent);
            this.pName = pName;
            this.value = value;
        }

        @Override
        public void store(CodeWriter out) {
            if (this.pName != null && this.pName.length() > 0) {
                out.print(this.pName);
                out.print("=");
            }
            this.value.store(out);
        }
    }
}

