/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTypeSpec;

public class PythonCodeTryBlock
extends PythonCodeBlock {
    private List<PythonCodeExceptBlock> excepts = new ArrayList<PythonCodeExceptBlock>();
    private PythonCodeBlock elseBlock;
    private PythonCodeBlock finallyBlock;

    public PythonCodeTryBlock(IPythonCodeElement parent) {
        super(parent);
    }

    public PythonCodeBlock addExcept() {
        PythonCodeExceptBlock e = new PythonCodeExceptBlock(this);
        this.excepts.add(e);
        return e;
    }

    public PythonCodeBlock addExcept(String type) {
        PythonCodeExceptBlock e = new PythonCodeExceptBlock(this, type);
        this.excepts.add(e);
        return e;
    }

    public PythonCodeBlock addExcept(String type, String name) {
        PythonCodeExceptBlock e = new PythonCodeExceptBlock(this, type, name);
        this.excepts.add(e);
        return e;
    }

    public PythonCodeBlock addExceptStar() {
        PythonCodeExceptBlock e = new PythonCodeExceptBlock(this);
        e.setStar();
        this.excepts.add(e);
        return e;
    }

    public PythonCodeBlock addExceptStar(String type) {
        PythonCodeExceptBlock e = new PythonCodeExceptBlock(this, type);
        e.setStar();
        this.excepts.add(e);
        return e;
    }

    public PythonCodeBlock addExceptStar(String type, String name) {
        PythonCodeExceptBlock e = new PythonCodeExceptBlock(this, type, name);
        e.setStar();
        this.excepts.add(e);
        return e;
    }

    public PythonCodeBlock addElse() {
        this.elseBlock = new PythonCodeBlock(this);
        return this.elseBlock;
    }

    public PythonCodeBlock addFinally() {
        this.finallyBlock = new PythonCodeBlock(this);
        return this.finallyBlock;
    }

    @Override
    public void store(CodeWriter out) {
        out.printlnwi("try:");
        out.increaseIndent();
        super.store(out);
        out.decreaseIndent();
        for (PythonCodeExceptBlock e : this.excepts) {
            e.store(out);
        }
        if (this.elseBlock != null) {
            out.printlnwi("else:");
            out.increaseIndent();
            this.elseBlock.store(out);
            out.decreaseIndent();
        }
        if (this.finallyBlock != null) {
            out.printlnwi("finally:");
            out.increaseIndent();
            this.finallyBlock.store(out);
            out.decreaseIndent();
        }
    }

    public class PythonCodeExceptBlock
    extends PythonCodeBlock {
        private PythonCodeTypeSpec type;
        private String name;
        private boolean star;

        public PythonCodeExceptBlock(IPythonCodeElement parent) {
            super(parent);
            this.star = false;
        }

        public PythonCodeExceptBlock(IPythonCodeElement parent, String type) {
            super(parent);
            this.star = false;
            this.type = new PythonCodeTypeSpec(type, parent);
        }

        public PythonCodeExceptBlock(IPythonCodeElement parent, String type, String name) {
            super(parent);
            this.star = false;
            this.type = new PythonCodeTypeSpec(type, parent);
            this.name = name;
        }

        private void setStar() {
            this.star = true;
        }

        @Override
        public void store(CodeWriter out) {
            out.printwi("except");
            if (this.star) {
                out.print("*");
            }
            if (this.type != null) {
                out.print(" ");
                this.type.store(out);
            }
            if (this.name != null) {
                out.print(" as " + this.name);
            }
            out.println(":");
            out.increaseIndent();
            super.store(out);
            out.decreaseIndent();
        }
    }
}

