/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.logger;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import net.ssehub.easy.basics.logger.AbstractJavaLogger;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;

public class FileLogger
extends AbstractJavaLogger {
    private static FileLogger instance;
    private Handler fileHandler;
    private Logger logger = FileLogger.createLogger(FileLogger.class, null);

    private FileLogger(String path, boolean append) throws SecurityException, IOException {
        this.fileHandler = new FileHandler(path, append);
        this.fileHandler.setFormatter(LOG_FORMATTER);
        this.logger.addHandler(this.fileHandler);
    }

    public static synchronized FileLogger getInstance(String path, boolean append) {
        if (instance == null) {
            try {
                instance = new FileLogger(path, append);
            }
            catch (SecurityException e) {
                EASyLoggerFactory.INSTANCE.getLogger(FileLogger.class, "net.ssehub.easy.basics").exception(e);
            }
            catch (IOException e) {
                EASyLoggerFactory.INSTANCE.getLogger(FileLogger.class, "net.ssehub.easy.basics").exception(e);
            }
        }
        return instance;
    }

    @Override
    public void info(String msg, Class<?> clazz, String bundleName) {
        this.logger.info("[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void error(String msg, Class<?> clazz, String bundleName) {
        this.logger.severe("[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void warn(String msg, Class<?> clazz, String bundleName) {
        this.logger.warning("[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void debug(String msg, Class<?> clazz, String bundleName) {
        this.logger.log(DEBUG_LEVEL, "[" + clazz.getSimpleName() + "] " + msg);
    }

    @Override
    public void exception(String msg, Class<?> clazz, String bundleName) {
        this.logger.log(EXCEPTION_LEVEL, "[" + clazz.getSimpleName() + "] " + msg);
    }
}

