/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.basics.modelManagement;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.IModelRepository;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.ResolutionContext;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionedModelInfos;

public class DefaultImportResolver<M extends IModel>
extends ImportResolver<M> {
    public static final boolean IMPORT_WITH_VERSION = true;
    private final ModelInfo<M> conflictMarker = new ModelInfo();
    private final Map<ModelInfo<M>, M> localModelOverride = new HashMap<ModelInfo<M>, M>();
    private boolean allowCycles;

    public DefaultImportResolver() {
        this(false);
    }

    public DefaultImportResolver(boolean allowCycles) {
        this.allowCycles = allowCycles;
    }

    @Override
    public void clear() {
        this.localModelOverride.clear();
        super.clear();
    }

    @Override
    public List<IMessage> resolveImports(M model, URI uri, List<ModelInfo<M>> inProgress, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) {
        ModelInfo<M> info = repository.getModelInfo(model.getName(), model.getVersion(), uri);
        if (info != null) {
            this.localModelOverride.put(info, model);
        }
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        ResolutionContext<M> context = new ResolutionContext<M>(model, uri, inProgress, repository, evaluationContext);
        HashSet done = new HashSet();
        List<ModelImport<M>> conflicts = this.resolveImports(context, done, messages);
        done.clear();
        if (!this.allowCycles) {
            this.checkImportCycles(model, messages, done);
        }
        try {
            if (conflicts != null || context.getConflict(model) != null) {
                messages.add(new Message("import conflict on model '" + model.getName() + "', cannot resolve the import", Status.ERROR));
            }
        }
        catch (RestrictionEvaluationException e) {
            messages.add(new Message(e.getMessage(), Status.ERROR));
        }
        if (info != null) {
            this.localModelOverride.put(info, model);
        }
        return messages;
    }

    private void checkImportCycles(M model, List<IMessage> messages, Set<M> done) {
        if (done.contains(model)) {
            messages.add(new Message("cyclic import of '" + model.getName() + "' is forbidden", Status.ERROR));
        } else {
            done.add(model);
            int i = 0;
            while (i < model.getImportsCount()) {
                ModelImport<?> imp = model.getImport(i);
                if (imp.getResolved() != null) {
                    this.checkImportCycles(imp.getResolved(), messages, done);
                }
                ++i;
            }
            done.remove(model);
        }
    }

    /*
     * Exception decompiling
     */
    private List<ModelImport<M>> resolveImports(ResolutionContext<M> context, HashSet<M> done, List<IMessage> messages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setUnresolved(M model, List<ModelImport<M>> conflicts) {
        int i = 0;
        while (i < model.getImportsCount()) {
            this.setUnresolved(model, model.getImport(i), conflicts);
            ++i;
        }
        this.setUnresolved(model, model.getSuper(), conflicts);
    }

    private void setUnresolved(M model, ModelImport<M> imp, List<ModelImport<M>> conflicts) {
        if (imp != null) {
            try {
                M resolved = imp.getResolved();
                if (resolved != null) {
                    boolean unresolve = false;
                    if (conflicts != null) {
                        int i = 0;
                        while (unresolve && i < conflicts.size()) {
                            unresolve = conflicts.get(i).getResolved() == resolved;
                            ++i;
                        }
                    } else {
                        unresolve = true;
                    }
                    if (unresolve) {
                        this.setUnresolved(resolved, conflicts);
                        imp.setResolved(null);
                    }
                }
            }
            catch (ModelManagementException e) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").exception(e);
            }
        }
    }

    private void handleImports(ResolutionContext<M> context, M model, List<ModelImport<M>> todo) {
        int i = 0;
        while (i < model.getImportsCount()) {
            this.handleImport(context, model.getImport(i), todo);
            ++i;
        }
        this.handleImport(context, model.getSuper(), todo);
    }

    private void handleImport(ResolutionContext<M> context, ModelImport<?> imp, List<ModelImport<M>> todo) {
        if (imp != null) {
            ModelImport<?> i = imp;
            if (i.isConflict()) {
                context.addConflict(i);
            } else if (todo != null) {
                todo.add(i);
            }
        }
    }

    private ModelInfo<M> determineMatching(ResolutionContext<M> context, List<VersionedModelInfos<M>> versions, IVersionRestriction restriction) throws ModelManagementException {
        ModelInfo result;
        int candidatesSize;
        ArrayList<ModelInfo<int>> candidates = new ArrayList<ModelInfo<int>>();
        boolean hasConflicts = false;
        if (versions != null) {
            int v = 0;
            int n = versions.size();
            while (v < n) {
                VersionedModelInfos<int> vInfos = versions.get(v);
                int i = 0;
                int vn = vInfos.size();
                while (i < vn) {
                    ModelInfo<int> info = vInfos.get(i);
                    try {
                        boolean isOk;
                        boolean bl = isOk = restriction == null || restriction.evaluate(context.getEvaluationContext(), info.getVersion());
                        if (isOk && context.isInProjectFolder(info)) {
                            if (context.isConflict(info)) {
                                hasConflicts = true;
                            } else {
                                candidates.add(info);
                            }
                        }
                    }
                    catch (RestrictionEvaluationException e) {
                        throw new ModelManagementException(e.getMessage(), e.getId());
                    }
                    ++i;
                }
                ++v;
            }
        }
        if ((candidatesSize = candidates.size()) == 0) {
            result = hasConflicts ? this.conflictMarker : null;
        } else if (1 == candidatesSize) {
            result = (ModelInfo)candidates.get(0);
        } else {
            ModelInfo highest = (ModelInfo)candidates.get(0);
            int i = 1;
            while (i < candidatesSize) {
                ModelInfo info = (ModelInfo)candidates.get(i);
                Version iVersion = info.getVersion();
                if (highest.getVersion() == null && iVersion != null) {
                    highest = info;
                } else if (iVersion != null && iVersion.compareTo(highest.getVersion()) > 0) {
                    highest = info;
                }
                ++i;
            }
            result = highest;
            ArrayList tmp = new ArrayList();
            int i2 = 0;
            while (i2 < candidatesSize) {
                ModelInfo info = (ModelInfo)candidates.get(i2);
                if (Version.equals(highest.getVersion(), info.getVersion())) {
                    tmp.add(info);
                }
                ++i2;
            }
            result = VersionedModelInfos.getByClosestUri(tmp, context.getModelURI(), context.getModelPaths());
            if (result == null) {
                result = highest;
            }
        }
        return result;
    }

    private List<ModelImport<M>> addConflict(List<ModelImport<M>> conflicts, ModelImport<M> conflict) {
        if (conflict != null) {
            if (conflicts == null) {
                conflicts = new ArrayList<ModelImport<M>>();
            }
            conflicts.add(conflict);
        }
        return conflicts;
    }

    private List<ModelImport<M>> resolve(ResolutionContext<M> context, HashSet<M> done, List<IMessage> messages, List<VersionedModelInfos<M>> versions, ModelImport<M> imp) {
        ModelInfo<M> toLoad;
        List<ModelImport<M>> conflicts = null;
        try {
            toLoad = this.determineMatching(context, versions, imp.getVersionRestriction());
            if (this.conflictMarker == toLoad) {
                this.addConflict(conflicts, imp);
            }
        }
        catch (ModelManagementException e) {
            toLoad = null;
            messages.add(new Message(e.getMessage(), Status.ERROR));
        }
        if (toLoad != null && toLoad != this.conflictMarker) {
            conflicts = this.load(context, done, toLoad, messages, imp, conflicts);
        } else if (toLoad == null) {
            messages.add(new Message("model '" + imp.getName() + "' cannot be resolved as no model matches the import specification", Status.ERROR));
        }
        return conflicts;
    }

    protected void cannotResolveImport(ModelImport<M> imp, List<IMessage> messages, URI modelURI, IRestrictionEvaluationContext context) {
        messages.add(new Message("model '" + imp.getName() + "' cannot be found", Status.ERROR));
    }

    private List<ModelImport<M>> load(ResolutionContext<M> context, HashSet<M> done, ModelInfo<M> toLoad, List<IMessage> messages, ModelImport<M> imp, List<ModelImport<M>> conflicts) {
        block15: {
            M model = context.getModel();
            if (model != null && ModelInfo.equals(toLoad, model.getName(), model.getVersion(), context.getModelURI())) {
                messages.add(new Message("model '" + imp.getName() + "' cannot import itself", Status.ERROR));
            } else {
                IModelRepository<M> repository = context.getModelRepository();
                IModel found = (IModel)this.localModelOverride.get(toLoad);
                if (found == null && ((found = toLoad.getResolved()) == null && context.considerLoading(this.isTransitiveLoadingEnabled()) || repository.isOutdated(toLoad))) {
                    if (!context.isLoop(toLoad)) {
                        this.notifyProcessing(toLoad, IModelProcessingListener.Type.LOADING, true);
                        found = repository.load(toLoad, this, messages);
                        this.notifyProcessing(toLoad, IModelProcessingListener.Type.LOADING, false);
                    } else {
                        messages.add(new Message("Model '" + imp.getName() + "' cannot be resolved here due to errors in the imported model", Status.ERROR));
                    }
                }
                try {
                    if (found != null) {
                        if (this.checkImported(imp, found, messages)) {
                            this.handleImports(context, found, null);
                            try {
                                conflicts = this.addConflict(conflicts, context.getConflict((IModel)context.getModel()));
                            }
                            catch (RestrictionEvaluationException e) {
                                messages.add(new Message(e.getMessage(), Status.ERROR));
                            }
                            if (conflicts == null) {
                                imp.setResolved(found);
                            }
                        }
                        if (conflicts == null) {
                            ResolutionContext<IModel> ctx = new ResolutionContext<IModel>(found, toLoad.getLocation(), context);
                            ctx.addConflicts(context);
                            conflicts = ResolutionContext.addConflicts(conflicts, this.resolveImports(ctx, done, messages));
                            if (conflicts == null) {
                                context.addConflicts(ctx);
                            } else {
                                imp.setResolved(null);
                            }
                        }
                        break block15;
                    }
                    imp.setResolved(null);
                    this.localModelOverride.remove(toLoad);
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").exception(e);
                }
            }
        }
        return conflicts;
    }

    protected boolean checkImported(ModelImport<M> imp, M model, List<IMessage> messages) {
        return true;
    }

    @Override
    public M resolve(String modelName, IVersionRestriction restrictions, URI baseUri, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) throws ModelManagementException {
        M result = null;
        if (ModelImport.isWildcard(modelName)) {
            ArrayList<M> imports = new ArrayList<M>();
            for (String name : repository.getMatchingModelNames(modelName)) {
                M resolved = this.resolveSingle(name, restrictions, baseUri, repository, evaluationContext);
                if (resolved == null) continue;
                imports.add(resolved);
            }
            result = repository.createModel(modelName, imports);
        } else {
            result = this.resolveSingle(modelName, restrictions, baseUri, repository, evaluationContext);
        }
        return result;
    }

    private M resolveSingle(String modelName, IVersionRestriction restrictions, URI baseUri, IModelRepository<M> repository, IRestrictionEvaluationContext evaluationContext) throws ModelManagementException {
        M result = null;
        ResolutionContext<M> context = new ResolutionContext<M>(modelName, baseUri, repository, evaluationContext);
        List<VersionedModelInfos<M>> versions = context.getModelRepository().getAvailable(modelName);
        ModelInfo<M> toLoad = this.determineMatching(context, versions, restrictions);
        if (toLoad != null && toLoad != this.conflictMarker && ((result = (M)toLoad.getResolved()) == null || repository.isOutdated(toLoad))) {
            ArrayList<IMessage> messages = new ArrayList<IMessage>();
            result = repository.load(toLoad, this, messages);
            if (!messages.isEmpty()) {
                boolean isError = false;
                StringBuilder tmp = new StringBuilder();
                int m = 0;
                int n = messages.size();
                while (m < n) {
                    IMessage msg = (IMessage)messages.get(m);
                    isError |= Status.ERROR == msg.getStatus();
                    if (tmp.length() > 0) {
                        tmp.append(", ");
                    }
                    tmp.append(msg.getDescription());
                    ++m;
                }
                if (isError) {
                    throw new ModelManagementException(tmp.toString(), 10503);
                }
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.basics").info(tmp.toString());
            }
        }
        return result;
    }

    private List<ModelImport<M>> resolve(ResolutionContext<M> context, HashSet<M> done, List<IMessage> messages) {
        List<ModelImport<M>> conflicts = null;
        ModelImport<M> imp = context.getToResolve();
        if (!imp.isConflict() && imp.getResolved() == null) {
            if (imp.isWildcard()) {
                ArrayList<M> imports = new ArrayList<M>();
                for (String name : context.getModelRepository().getMatchingModelNames(imp.getName())) {
                    ModelImport<M> tmpImp = imp.copy(name);
                    List<VersionedModelInfos<M>> versions = context.filterByLocations(context.getModelRepository().getAvailable(name));
                    if (versions != null && versions.size() > 0) {
                        conflicts = this.add(conflicts, this.resolve(context, done, messages, versions, tmpImp));
                    } else if (!imp.isWildcard()) {
                        this.cannotResolveImport(tmpImp, messages, context.getModelURI(), context.getEvaluationContext());
                    }
                    if (tmpImp.getResolved() == null) continue;
                    imports.add(tmpImp.getResolved());
                }
                try {
                    imp.setResolved(context.getModelRepository().createModel(imp.getName(), imports));
                }
                catch (ModelManagementException e) {
                    messages.add(new Message(e.getMessage(), Status.ERROR));
                }
            } else {
                List<VersionedModelInfos<M>> versions = context.filterByLocations(context.getModelRepository().getAvailable(imp.getName()));
                if (versions != null && versions.size() > 0) {
                    conflicts = this.resolve(context, done, messages, versions, imp);
                } else {
                    this.cannotResolveImport(imp, messages, context.getModelURI(), context.getEvaluationContext());
                }
            }
        }
        return conflicts;
    }

    private List<ModelImport<M>> add(List<ModelImport<M>> orig, List<ModelImport<M>> add) {
        if (orig == null) {
            orig = add;
        } else if (add != null) {
            orig.addAll(add);
        }
        return orig;
    }
}

